<?php

namespace Eventflow\Interlink\Client;


class Response {
	/**
	 * @var array key-value pairs
	 */
	private $_aHeaders = array();
	private $_sBody;
	private $_iStatusCode;

	public function __construct( $sResponse = null ) {
		$this->_parseResponse( $sResponse );
	}

	/**
	 * @param  $response
	 *
	 * @return void
	 */
	private function _parseResponse( $response ) {
		if ( ! $response ) {
			return;
		}

		list( $sHeaders, $this->_strBody ) = explode( "\r\n\r\n", $response );

		$aHeaders = explode( "\r\n", $sHeaders );

		$sStatusCode        = array_shift( $aHeaders );
		$this->_iStatusCode = intval( substr( $sStatusCode, 9, 3 ) );

		foreach ( $aHeaders as $header ) {
			$v = preg_split( "/\: +/", $header, null, PREG_SPLIT_NO_EMPTY );
			list( $key, $value ) = $this->_normalizeHeader( $v[0], $v[1] );
			$this->_aHeaders[ $key ] = $value;
		}
	}

	private function _normalizeHeader( $key, $value ) {
		return array( strtoupper( preg_replace( "/-/", "_", $key ) ), trim( $value, " \"'" ) );
	}

	public function getStatusCode() {
		return $this->_iStatusCode;
	}

	public function getHeader( $sKey ) {
		return $this->_aHeaders[ $sKey ];
	}

	public function getBody() {
		return $this->_sBody;
	}

	public function getHeaders() {
		return $this->_aHeaders;
	}

	public function setStatusCode( $iStatusCode ) {
		$this->_iStatusCode = $iStatusCode;
	}

	public function setHeaders( array $aHeaders ) {
		foreach ( $aHeaders as $key => $value ) {
			list( $key, $value ) = $this->_normalizeHeader( $key, $value );
			$this->_aHeaders[ $key ] = $value;
		}
	}

	public function setBody( $sBody ) {
		$this->_sBody = $sBody;
	}

}
