<?php

namespace Eventflow\Interlink\Client;

use Eventflow\Interlink\OAuth\Request;


/**
 * PUT and DELETE are implemented as a POST with an X-Http-Method-Override header.
 * Public methods in this class should be treated as package-scoped.
 */
class Decorated_Request {

	private $_aHeaders = array();
	private $_sURL;

	public function __construct( Request $oRequest ) {
		$this->_oRequest = $oRequest;
		if ( $this->_oRequest->getNormalizedHTTPMethod() !== 'GET' ) {
			$a = preg_split( '/\: +/', $this->_oRequest->toHeader() );
			$this->addHeader( 'Authorization', array_pop( $a ) );
			$this->_sURL = $this->_oRequest->getNormalizedURL();
		} else {
			$this->_sURL = $this->_oRequest->toURL();
		}
	}

	public function setXHttpMethodOverride( $sHttpMethod ) {
		$this->addHeader( 'X-Http-Method-Override', strtoupper( $sHttpMethod ) );
	}

	public function addHeader( $sKey, $sHeader ) {
		$this->_aHeaders[ $sKey ] = $sHeader;
	}

	public function getHTTPMethod() {
		return $this->_oRequest->getNormalizedHTTPMethod();
	}

	public function getURL() {
		return $this->_sURL;
	}

	public function getHeaders() {
		return $this->_aHeaders;
	}

	public function getBody() {
		return $this->_oRequest->getContent();
	}

	public function __toString() {
		$sRequest = $this->_oRequest->getNormalizedHTTPMethod() . " " . $this->_oRequest->getNormalizedURL() . " HTTP/1.1\r\n";
		$sRequest .= "Host: " . $this->_oRequest->getNormalizedURL() . "\r\n";
		$sRequest .= "Accept: */*\r\n";
		$sRequest .= "Connection: Keep-Alive\r\n";

		foreach ( $this->_aHeaders as $key => $value ) {
			$sRequest .= $key . ": " . $value . "\r\n";
		}

		if ( $sBody = $this->getBody() ) {
			$sRequest .= "Content-Length: " . strlen( $sBody ) . "\r\n\r\n" . $sBody;
		} else {
			$sRequest .= "\r\n";
		}

		return $sRequest;
	}

}
