<?php

namespace Eventflow\Interlink\Client;


/**
 * CURL fallback if WP_Http is unavailable
 */
class CURL_Invoker extends Abstract_Invoker implements Invoker {

	private $_curlHandler;

	protected function _execute() {

		$this->_curlHandler = curl_init();

		curl_setopt( $this->_curlHandler, CURLOPT_URL, $this->_oRequest->getURL() );
		curl_setopt( $this->_curlHandler, CURLOPT_FOLLOWLOCATION, true );
		curl_setopt( $this->_curlHandler, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $this->_curlHandler, CURLOPT_VERBOSE, false );

		// decide if we should use X-Http-Method-Override
		$_bOverride = $this->_oRequest->getHTTPMethod() !== 'GET';

		curl_setopt( $this->_curlHandler, CURLOPT_POST, $_bOverride );
		if ( $_bOverride && $this->_oRequest->getBody() ) {
			curl_setopt( $this->_curlHandler, CURLOPT_POSTFIELDS, $this->_oRequest->getBody() );
		}

		curl_setopt( $this->_curlHandler, CURLOPT_HEADER, true );
		curl_setopt( $this->_curlHandler, CURLOPT_HTTPHEADER, $this->_oRequest->getHeaders() );

		$response = curl_exec( $this->_curlHandler );
		curl_close( $this->_curlHandler );

		return $response;
	}

}
