<?php

namespace Eventflow\Interlink\Client;


abstract class Abstract_Invoker implements Invoker {
	protected $_oRequest;

	public function __construct( Decorated_Request $oRequest = null ) {
		$this->_oRequest = $oRequest;
	}

	/**
	 * @return Response|null
	 */
	public function request() {
		if ( $sResponse = $this->_execute() ) {
			return new Response( $sResponse );
		} else {
			return null;
		}
	}

	public function setRequest( Decorated_Request $oRequest ) {
		$this->_oRequest = $oRequest;
	}

	abstract protected function _execute();

}
