<?php

/**
 * Bootstrap file
 *
 * @link              https://www.eventflow.ru/wordpress_en.html
 * @since             1.0.0
 * @package           Eventflow_Interlink
 *
 * @wordpress-plugin
 * Plugin Name:       Eventflow Keyword Extraction
 * Plugin URI:        https://www.eventflow.ru/wordpress_en.html
 * Description:       Automatic keyword extraction for SEO enhancement and improved user experience.
 * Version:           1.0.0
 * Author:            Eventflow API
 * Author URI:        https://www.eventflow.ru/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       eventflow-interlink
 * Domain Path:       /languages
 */

// abort if called directly
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Start at version 1.0.0 and use SemVer - https://semver.org
 */
define( 'EVENTFLOW_INTERLINK_PLUGIN_VERSION', '1.0.0' );
define( 'EVENTFLOW_INTERLINK_PHP_MINIMUM', '5.3.0' );

define( 'EVENTFLOW_INTERLINK_USER_AGENT', 'Eventflow API WP Client' );

define( 'EVENTFLOW_INTERLINK_CONSUMER_KEY', 'rdwp_consumer_key' );
define( 'EVENTFLOW_INTERLINK_CONSUMER_SECRET', 'rdwp_consumer_secret' );

define( 'EVENTFLOW_API_REQUEST_TOKEN_ENDPOINT', 'https://eventflow.ru/api/oauth/request_token' );
define( 'EVENTFLOW_API_ACCESS_TOKEN_ENDPOINT', 'https://eventflow.ru/api/oauth/access_token' );
define( 'EVENTFLOW_API_KEYWORD_EXTRACTION_ENDPOINT', 'https://eventflow.ru/api/v1/keywords' );

define( 'EVENTFLOW_INTERLINK_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'EVENTFLOW_INTERLINK_PLUGIN_URL', plugin_dir_url( __FILE__ ) );


function activate_eventflow_interlink() {
	do_action( 'eventflow_interlink_activation' );
}

register_activation_hook( __FILE__, 'activate_eventflow_interlink' );

function deactivate_eventflow_interlink() {
	// nothing yet
}

register_deactivation_hook( __FILE__, 'deactivate_eventflow_interlink' );

if ( version_compare( PHP_VERSION, EVENTFLOW_INTERLINK_PHP_MINIMUM, '>=' ) ) {
	require_once EVENTFLOW_INTERLINK_PLUGIN_PATH . '/includes/vendor/autoload.php';
	( Eventflow\Interlink\Plugin::getInstance() )->register();
}
