window.evfl = window.evfl || {};
evfl.onClick = function () {
    clearInterval(evfl.timer); // if previous onClick did not finish properly
    let i = 0;
    evfl.timer = setInterval(function () {
        i = ++i % 10;
        jQuery('#evfl_message').html(evfl_l10n.loading + Array(i + 1).join("."));
    }, 150);

    jQuery.ajax({
        type: 'POST',
        url: evfl_l10n.admin_ajax_url,
        data: {
            action: 'evfl_extract',
            post_id: evfl_l10n.post_id
        },
        success: function (response) {
            clearInterval(evfl.timer);
            var keywords = response.data;
            jQuery('#tax-input-keyword').val(keywords.join(evfl_l10n.tag_delimiter));
            jQuery('#evfl_message').html(response.message);
            tagBox.init();
        },
        error: function () {
            clearInterval(evfl.timer);
            jQuery('#evfl_message').html('AJAX call failed');
        }
    })
};

jQuery(document).ready(function () {
    tagBox.init();
    jQuery('#evfl_keywords_btn').click(evfl.onClick);
});