const path = require('path');
const CopyWebpackPlugin = require('copy-webpack-plugin'); // Import the plugin
const webpack = require('webpack');

// Determine if we're in development mode
const isDevelopment = process.env.NODE_ENV === 'development';

module.exports = {
  entry: './src/index.js',  // Entry point for our package
  output: {
    path: path.resolve(__dirname, 'dist'),
    filename: 'component-bundle.js',  // Output bundle
    library: 'EventComponents',  // Expose the components globally
    libraryTarget: 'umd',
    globalObject: 'this',
    libraryExport: 'default',
  },
  mode: isDevelopment ? 'development' : 'production',
  devtool: isDevelopment ? 'source-map' : false, // Source maps only in development
  watch: isDevelopment,
  externals: {
    jquery: 'jQuery', // ✅ Do not bundle jQuery — use global WP jQuery
  },
  module: {
    rules: [
      {
        test: /\.js$/,
        exclude: /node_modules/,
        use: 'babel-loader',
      },
      {
        test: /\.css$/,
        use: ['style-loader', 'css-loader'],
      },
      {
        test: /\.(jpg|jpeg|png|gif|svg)$/i,
        type: 'asset/resource',
        generator: {
          filename: 'images/[name][ext][query]'  // Output images into dist/images folder
        },
      },
    ],
  },
  resolve: {
    extensions: ['.js', '.css'],
  },
  plugins: [
    // new CopyWebpackPlugin({
    //   patterns: [
    //     {
    //       from: path.resolve(__dirname, 'dist'), // Source: dist folder
    //       to: path.resolve(__dirname, '../eb-embedv2/dist'), // Destination: target project folder
    //     },
    //   ],
    // }),
    new webpack.ProvidePlugin({
      $: 'jquery',
      jQuery: 'jquery',
      'window.jQuery': 'jquery',
    }),
  ],
};
