export class Constants {
     static DOCS_GOOGLE_VIEWER_URL = "https://docs.google.com/viewer";

     static EVENT_TYPE = {
          VENUE: 'venue_event',
          ONLINE: 'online_event'
     };

     static WIDGET_TYPE = {
          TICKET_PAGE: 1,
          BUTTON: 3,
     };

     static TICKET_CATEGORY = {
          DONATION: 'donation',
          TICKET: 'ticket',
     };
     static EVENT_TYPE_NUMBER = {
          VENUE: 1,
          VIRTUAL: 2,
          UNDECIDED: 3,
     };

     static DEFAULT_DATE_FORMAT = "ddd, MMM DD, YYYY h:mm A";

     static EVENT_RESOURCE_TEXT = 'text';
     static EVENT_RESOURCE_IMAGE = 'image';
     static EVENT_RESOURCE_VIDEO = 'video';
     static EVENT_RESOURCE_PDF = 'pdf';
     static EMBED_BUTTON_SHAPE_CURVE = 2;
     static SupportedCurrencySigns = {
          "AUD": "$",
          "USD": "$",
          "GBP": "£",
          "NZD": "$",
          "CAD": "$",
          "EUR": "€",
          "BRL": "R$",
          "CNY": "¥",
          "DKK": "kr",
          "EGP": "E£",
          "HUF": "Ft",
          "IDR": "Rp",
          "JOD": "د.ا",
          "MYR": "RM",
          "NOK": "kr",
          "PHP": "₱",
          "RON": "lei",
          "SAR": "ر.س",
          "SGD": "$",
          "ZAR": "R",
          "KRW": "₩",
          "SEK": "kr",
          "CHF": "Fr",
          "TWD": "NT$",
          "THB": "฿",
          "AED": "د.إ",
          "FJD": "$",
          "QAR": "ر.ق",
          "ARS": "$",
          "JPY": "¥",
          "BGN": "лв",
          "CZK": "Kč",
          "MXN": "$",
          "BDT": "৳",
          "PLN": "zł",
          "GIP": "£",
          "INR": "₹"
      };

     static TYPE_OF_OCCURRENCE = {
          DOES_NOT_REPEAT : 'does_not_repeat',
          REPEATE_DAILY : 'daily',
          REPEATE_WEEKLY : 'weekly',
          REPEATE_MONTHLY : 'monthly',
          SCHEDULE : 'schedule',
          TIMESLOTS : 'timeslots',
     };

     static DAYS = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
     static MONTHS = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

     static TIMESLOTS_STATUS = {
          TIMESLOTS_AVAILABLE: 1,
          TIMESLOTS_UNAVAILABLE: 0,
          TIMESLOTS_BOOKED: 2,
          TIMESLOTS_AVAILABLE_TEXT: "available",
          TIMESLOTS_UNAVAILABLE_TEXT: "unavailable",
          TIMESLOTS_BOOKED_TEXT: "booked",
          TIMESLOTS_SOLDOUT_TEXT: "soldout",
     }

     static CAPACITY_UNLIMITED = -1;

     static BOOKING_STARTS_ON = {
          immediate : 'immediate',
          specific_time : 'specific_time',
          relative_to_occurrence : 'relative_to_occurrence',
          number_of_hours : 'number_of_hours',
          number_of_days : 'number_of_days'
     }

     static BOOKING_ENDS_ON = {
          continue_until_event_ends : 'continue_until_event_ends',
          specific_time : 'specific_time',
          relative_to_occurrence : 'relative_to_occurrence',
          number_of_hours : 'number_of_hours',
          number_of_days : 'number_of_days'
     }


     static DISCOUNT_STARTS_AND_ENDS_ON = {
          specific_time : 'specific_time',
          relative_to_occurrence : 'relative_to_occurrence',
          number_of_hours : 'number_of_hours',
          number_of_days : 'number_of_days'
     }

     static EB_DEFAULT_TIMEZONE = 'Australia/Melbourne';//-->For custom use whenever needed!
     static APP_DEFAULT_TIMEZONE = 'UTC';//-->For application system use!

     static SESSION_ACTIVE = 1;


}