const moment = require('moment-timezone');
import {Helpers} from '../../utils/helpers';
import {TicketValidation} from "../../utils/ticket_validation";

export class AddMoreSessionModal {
    static getModal = () => {
        return `<div class="eb-modal-wrapper eb-d-none eb-add-more-session-modal" id="addMoreSessionModal">
            <div class="eb-modal-wrap">
                <div class="eb-modal-dialog">
                    <div class="eb-modal-content">
                        <div class="eb-modal-header">
                            <div class="eb-modal-title">
                                <h3>Would you like to add another session?</h3>
                            </div>
                            <button onclick="Helpers.closeModal('#addMoreSessionModal')" type="button" class="eb-modal-close"><i class="ebi-icon-close"></i></button>
                        </div>
                        
                        <div class="eb-modal-body">
                            <div class="eb-add-more-se-content">
                                <p>You have selected <span id="session_count"></span>. You can add additional sessions by clicking 'Add Another’. Click ‘Continue’ to proceed with your current selection.</p>
                            </div>
                        </div>
                        <div class="eb-modal-footer">
                            <button type="button" class="eb-btn-primary addAnotherSession" onclick="TicketValidation.showEventSessionList()">Add Another</button>
                            <button type="button" class="eb-btn-border occSubBtn" onclick="TicketValidation.submitTicketForm()">Continue</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>`
    }
}