import $ from 'jquery';
import '../../../js/mb-countdown/jquery.mb-comingsoon';
import '../../../js/mb-countdown/mb-comingsoon.css';
import {Helpers} from '../../utils/helpers';
import {Constants} from "../../utils/constants";
import {Components} from "../../utils/component";
import 'jquery-locationpicker';
import {Loader} from 'google-maps';
import '../../../icon-fonts/style.css';
import '../../../css/style.css';
import '../../../css/modal.css';
import './style.css';

import {SessionDetailsModals} from "../modals/SessionDetailsModals";
import {AddMoreSessionModal} from "../modals/AddMoreSessionModal";
import {TicketValidation} from "../../utils/ticket_validation";
import moment from 'moment';
import { Config } from '../../../config';


let c_date = new Date();
let day = c_date.getDay();
let month = c_date.getMonth();
let year = c_date.getFullYear();

function EventDetails(data) {
    const eventDetails = data?.eventDetails;
    const widgetConfig = data?.widgetConfig;
    const bookNowCallback = data?.bookNowCallback;
    // Send popup open/close status to parent
    const popupOpenStatus = data?.popupOpenStatus;


    if (!eventDetails) return null;

    let startOn = eventDetails?.occurrence?.attributes?.starts_on?.utc
    let eventDuration = eventDetails?.occurrence?.attributes?.event_duration;
    let eventPrice = Helpers.doGetTicketPriceLabel(eventDetails, eventDetails?.tickets);
    let eventVenue = Helpers.getEventVenue(eventDetails);
    const typeOfOccurrence = Helpers.getTheTypeOfOccurrence(eventDetails);
    let timeslotList = null;
    let eventDateListData = null;
    let bookedEventDateListData = null;
    let bookedEventDateList = null;
    let hasEventSessionForSell = Helpers.hasEventSessionForSell(eventDetails);
    let isTimeSlotEvent = Helpers.isTimeSlotEvent(eventDetails);
    let isEnableSellSession = eventDetails?.settings?.sell_session?.enabled;
    let eventStickerType = Helpers.eventStickerType(eventDetails);
    

    window.eventDetails = eventDetails;
    window.widgetConfig = widgetConfig;
    window.bookNowCallback = bookNowCallback;
    window.popupOpenStatus = popupOpenStatus;

    /*<p className="event-date">${Helpers.getEventStartDate()} |
        ${Helpers.getEventStartTime()} (${Helpers.getEventDuration()})</p>
    <div className="event-footer">
        <button className="book-button">Book Now</button>
        <p className="event-price">${Helpers.getEventMinTicketPrice(eventDetails)}</p>
    </div>*/

    const container = document.createElement('div');
    container.className = 'eb-details-wrapper';
    container.innerHTML = `
            <div class="eb-toast-msg-wrap error-toast eb-d-none">
                <div class="eb-toast-inner">
                    <div class="eb-toast-left-content">
                        <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28">
                            <path id="Path_18913" data-name="Path 18913" d="M64,30A14,14,0,1,0,78,44,14.005,14.005,0,0,0,64,30Zm1.4,21H62.6V42.6h2.8Zm0-11.2H62.6V37h2.8Z" transform="translate(-50 -30)" fill="#fff"></path>
                        </svg>
                        <p>Please add a ticket</p>
                    </div>
                    <button class="eb-btn" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" width="14.83" height="14.83" viewBox="0 0 14.83 14.83">
                            <g id="noun_Close_1746028" transform="translate(-5.586 -2.586)">
                                <path id="Path_17873" data-name="Path 17873" d="M5.478,7.415,0,1.937,1.937,0,7.415,5.478,12.893,0,14.83,1.937,9.352,7.415l5.478,5.478L12.893,14.83,7.415,9.352,1.937,14.83,0,12.893Z" transform="translate(5.586 2.586)" fill="#fff"></path>
                            </g>
                        </svg>
                    </button>
                </div>
            </div>
            
            <!--Event details-->
            <div class="eb-event-details-wrapper">
                <!--Top back button-->
                <div class="eb-container">
                    <div class="eb-event-title-wrap">
                        <div class="eb-back-btn">
                            <a id="backToHome" href="#">
                                <i class="ebi-icon-left-arrow"></i>
                                <span>Back to home</span>
                            </a>
                        </div>
                    </div>
                </div>
                
                <!--Event Banner-->
                <div class="eb-container eb-event-banner-main-wrap">
                    <h1 class="eb-event-title">${Helpers.getEventDisplayName(eventDetails)}</h1>

                    ${Components.getEventDetailsPageBannerHtml(eventDetails)}
                 </div>
                 
                 <!--Main body wrapper-->
                <div class="eb-event-main-body-wrapper">
                    <div class="eb-container">
                        <div class="eb-event-details-body">
                            
                            <!--Left body Content-->
                            <div class="eb-event-details-content">
                            
                                ${getEventDescription(eventDetails, widgetConfig)}
                                                            
                                <!--Resources-->
                                 <div class="eb-description-resources">
                                    ${getEventResources(eventDetails)}
                                </div>
                                
                                <!--Session section-->
                                ${!isEnableSellSession ? Components.getSellSessionList(eventDetails) : ''}
                                
                                <!--Map section-->
                                ${(!Helpers.isEmptyObject(eventVenue) && widgetConfig?.display_event_location_map !== false) ? `
                                    <section class="eb-map-section">
                                        <h4 class="eb-section-title">Find The Venue On Map</h4>
                                        <div class="eb-map-wrap">
                                            <!--<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d402590.5160342405!2d144.72350261181364!3d-37.97156521824676!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x6ad646b5d2ba4df7%3A0x4045675218ccd90!2sMelbourne%20VIC!5e0!3m2!1sen!2sau!4v1733369494599!5m2!1sen!2sau" width="100%" height="630" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>-->
                                            <div id="map" class="eb-map-render-wrap"></div>
                                        </div>
                                    </section>
                                ` : ``}
                                <!--End Map section-->  
                            </div>
                            
                            <!--Right Sidebar-->
                            <div class="eb-event-details-sidebar">
                            
                                <div class="eb-details-event-status-box eventDetailsStatusBox ${Helpers.isEmpty(Helpers.getEventStatus(eventDetails, eventStickerType)) ? 'eb-d-none':''}"> ${ Helpers.getEventStatus(eventDetails, eventStickerType)} </div>
                                
                                <div class="eb-side-box eb-error-msg eb-d-none">
                                    <span class="eb-error-text">This event has now concluded and is no longer active.</span>
                                </div>
                                
                                <div class="countDownBody"> 
                                    ${Components.getCountDownDom(eventDetails)}
                                </div>
                                
                                ${Components.getOccurrenceDropdown(eventDetails)}
                                
                                <div class="eb_event_details_date_time">
                                    ${Components.getEventDetailsDateTime(eventDetails, startOn)}
                                </div>
                                
                                ${!Helpers.isTimeSlotEvent(eventDetails) ? `
                                    <div class="eb-side-box">           
                                        <div class="eb-add-calender-btn-wrap">           
                                            <button type="button" class="eb-btn eb-add-calender-btn">Add Event Date to Calender</button>
                                            <div class="addCalender" style="display:none;">
                                                <div class="social-share">
                                                    <div class="eb-add-calender-title">
                                                        <h3>Add to</h3>
                                                        <a href="javascript:void(0);" id="addCalenderCloseButton" onclick="addCalenderCloseButton()">
                                                            <i class="ebi-icon-close"></i>
                                                        </a>
                                                    </div>
                                                    <div class="eb-add-calender-item-wrap">
                                                        <a class="windows" target="#">
                                                            <i class="ebi-windows-icon"></i> <span>Outlook</span>
                                                        </a>
                                                        <a class="apple" target="#">
                                                            <i class="ebi-apple-icon"></i> <span>Apple</span>
                                                        </a>
                                                        <a class="google" target="#">
                                                            <i class="ebi-google-icon"></i> <span>Google</span>
                                                        </a>
                                                        <a class="yahoo" target="#">
                                                            <i class="ebi-yahoo-icon"></i> <span>Yahoo</span>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                ` : ``}
                                
                                ${getEventLocation(eventDetails)}
                                
                                ${Helpers.isEnabledAgeRestriction(eventDetails) ? `
                                    <div class="eb-side-box eb-refund-policy">
                                        <h4 class="eb-side-title">Age Restriction</h4>
                                        <div class="eb-refund-details">
                                            <p>Must be ${Helpers.getAgeRestriction(eventDetails).condition.max} years old or above</p>
                                        </div>  
                                    </div>
                                ` : ``}
                                                         
                                 ${eventPrice != 'Free' ? `
                                     <div class="eb-side-box eb-refund-policy">
                                        <h4 class="eb-side-title">Refund Policy</h4>
                                        <div class="eb-refund-details">
                                            ${eventDetails?.refund?.available ? `
                                                <p>
                                                    ${!eventDetails?.refund?.policy?.automatic ? `
                                                        Orders are refundable for up to ${eventDetails?.refund?.policy?.cancel_before_event_starts} day${eventDetails?.refund?.policy?.cancel_before_event_starts > 1 ? 's' : ''} before the event. EventBookings fee is non-refundable.
                                                    ` : `
                                                        Orders are refundable (${eventDetails?.refund?.policy?.amount?.discount_unit}% of the ticket price) for up to ${eventDetails?.refund?.policy?.cancel_before_event_starts} day${eventDetails?.refund?.policy?.cancel_before_event_starts > 1 ? 's' : ''} before the event. EventBookings fee is non-refundable.
                                                    `}
                                                </p>
                                            ` : `
                                                <p>Orders are non refundable</p>
                                            `}
                                        </div>  
                                    </div>
                                 ` : ``}   
                               
                                 <div class="eb-side-box eb-event-price-box ${hasEventSessionForSell ? 'eb-d-none' : ''}">
                                    
                                    ${(eventPrice && widgetConfig?.display_ticket_price_on_event_page !== false) ? `
                                        <div class="eb-event-price eventPriceShowingSection">
                                            ${eventPrice}
                                        </div>  
                                        <span class="eb-event-price-tax">*Price before taxes</span>
                                    ` : ``}
                                    
                                    <div class="eb-purchase-btn-wrap ${eventStickerType == 'booking_end'? 'eb-d-none':''}">
                                        <button onclick="Components.openEventTicketPopup(eventDetails)" class="eb-book-btn ${eventStickerType == 'event_ended'? 'eb-disabled-all':''}" type="button">
                                            ${isTimeSlotEvent ? 'Select Date' : 'Purchase Ticket'}
                                        </button>
                                    </div>
                                </div>
                                
                                <div class="eb-side-box eb-payment-options">
                                    <div class="eb-payment-option-title"><i class="ebi-icon-lock"></i> <span>Secure Payment Options</span></div>
                                    <div class="eb-payment-options-icons">
                                        <img src="${Helpers.getFullPath("images/eb-payment-methods.svg")}" alt="Payment Methods">
                                    </div>
                                </div>
                                
                            </div>
                            <!--End Right Sidebar-->
                            
                        </div>
                    </div>
                    
                    <!--Session section-->
                    ${isEnableSellSession ? Components.getSellSessionList(eventDetails) : ''}
                    ${SessionDetailsModals.getModal()} 
                    
                </div>
                <!--Main body wrapper-->
                
                <!--Modal-->
                <div class="ebUpdateViewTicket">
                    ${Components.getTicketPopup(eventDetails, widgetConfig, false)}
                    ${AddMoreSessionModal.getModal()}
                </div>
            </div>
            
<!--            &lt;!&ndash;Checkout&ndash;&gt;-->
<!--            <div class="eb-event-checkout-wrapper eb-d-none">-->
<!--                -->
<!--            </div>-->
    `;

    // Convert the container to a jQuery object
    const $container = $(container);

    if (!Helpers.isEmptyObject(eventVenue)) {
        loadDependenciesAndInitializeMap(eventVenue);
    }

    const handleAddToCalender = () => {

        const calendarLink = Helpers.eventAddToCalendar(eventDetails, true);

        console.log({ calendarLink });

        $('.eb-add-calender-btn').click(() => {
            $('.addCalender').slideDown();
        });

        $('#addCalenderCloseButton').click(() => {
            $('.addCalender').slideUp();
        });

        $('.windows').click(() => {
            const link = document.createElement('a');
            link.href = calendarLink['add_to_calendar_link'];
            link.target = '_blank';
            link.click();
        });

        $('.apple').click(() => {
            const link = document.createElement('a');
            link.href = calendarLink['add_to_calendar_link'];
            link.target = '_blank';
            link.click();
        });

        $('.google').click(() => {
            const link = document.createElement('a');
            link.href = calendarLink['google_calendar_url'];
            link.target = '_blank';
            link.click();
        });

        $('.yahoo').click(() => {
            const link = document.createElement('a');
            link.href = calendarLink['yahoo_calendar_url'];
            link.target = '_blank';
            link.click();
        });
    }

    $(document).ready(function () {

        handleAddToCalender();
        // $(".eb-book-btn").click();

        $('.preview_pdf').on('load', function() {
            loadedPreviewPdfIframe(this);
        });

        initIntervalForPreviewPdf();

        Helpers.initializeSelect2Picker();

        // $('.select2Picker').select2();
        // Add click event handler for the "Book Now" button
        $container.on('click', '.book-button', function () {
            if (data?.bookNowCallback) {
                data?.bookNowCallback(eventDetails);
            }
        });

        let isRecurringEvent = Helpers.isRecurringEvent(eventDetails);
        let hasEventSessionForSell = Helpers.hasEventSessionForSell(eventDetails);

        if (isRecurringEvent && !hasEventSessionForSell) {
            $('#occurrencePicker').trigger('change');
        }

        $container.on('click', '#backToHome', function () {
            if (data?.backToHomeCallback) {
                data?.backToHomeCallback(eventDetails, widgetConfig);
            }
        });

        Helpers.initVideoPlayer();

        if(!isRecurringEvent){
            Helpers.initCountDownBar(eventDetails);
        }


        $('.owl-carousel').owlCarousel({
            loop:true,
            margin:25,
            nav: true,
            navText:["<i class='ebi-icon-left-angle'></i>","<i class='ebi-icon-right-angle'></i>"],
            responsiveClass:true,
            responsive:{
                0:{
                    items:1,
                    nav:true
                },
                600:{
                    items:2,
                    nav:false
                },
                1000:{
                    items:2,
                    nav:true,
                    loop:false
                }
            }
        })

        //Initialized donation ticket
        Helpers.initSliderContainer();

        //Initialized timeslot
        ({
            month,
            year,
            timeslotList,
            eventDateListData,
            bookedEventDateListData,
            bookedEventDateList
        } = Helpers.initTimeslotContainer(eventDetails));

    }).on('click', '.prevMonth', function(){
        year = (month === 0) ? year - 1 : year;
        month = (month === 0) ? 11 : month - 1;
        Helpers.renderSellAppointmentCalendar(month, year, eventDateListData, bookedEventDateList, bookedEventDateListData);
    }).on('click', '.eb_time_slots', function(){
        $('.eb_time_slots').removeClass('active');
        $(this).addClass('active');
    }).on('click', '.nextMonth', function(){
        year = (month === 11) ? year + 1 : year;
        month = (month + 1) % 12;
        Helpers.renderSellAppointmentCalendar(month, year, eventDateListData, bookedEventDateList, bookedEventDateListData);
    }).on('click', '.show_event', function(){
        $('.show_event').removeClass('active');
        $('#event').removeClass('d-none');
        $(this).addClass('active');
        let selectedOccurrenceUUID = $(this).attr('data-occurrence_uuid');
        Helpers.showAppointmentTimeslots(eventDetails, timeslotList, eventDateListData, false, selectedOccurrenceUUID);
        Helpers.autoSelectFirstAvailableTimeSlot();
    });

    return container;
}


function getEventResources(eventDetails) {
    if (!eventDetails?.resources?.length) {
        return '';
    }

    let resourcesHtml = "";
    eventDetails?.resources.forEach(function (resource, index) {

        let resourceType = resource.find(function (item) {
            return item.name === 'type';
        })['value'];

        let resourceContent = resource.find(function (item) {
            return item.name === 'content';
        })['value'];

        if (resourceType === Constants.EVENT_RESOURCE_TEXT) {
            resourcesHtml += `
                <div class="eb-event-resource-text">${resourceContent}</div>
            `;
        }

        if (resourceType === Constants.EVENT_RESOURCE_IMAGE) {
            resourcesHtml += `
                <div class="eb-event-resource-img">
                    <img class="" src="${Helpers.getImageFullUrl(resourceContent)}" onError="this.src='${Helpers.getEventFallbackImage()}'" alt=""/>
                </div>
            `;
        }

        if (resourceType === Constants.EVENT_RESOURCE_VIDEO) {
            let youtubeId = Helpers.getYoutubeEmbedUrl(resourceContent);

            if (youtubeId) {
                resourcesHtml += `
                    <div class="eb-video-content-block mrks-iframe-wrapper video-link-block-event-details">
                        <a href="javascript:void(0)" class="play-btn yt-play-btn mrks-iframe-pb">
                            <svg width="21" height="22" viewBox="0 0 21 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M19.308 10.6602C16.1131 8.97366 12.9401 7.29976 9.77057 5.62807C7.13579 4.23805 4.50363 2.84959 1.86359 1.45626L0.992188 0.996094V1.98861V20.3345V21.3246L1.8614 20.8695C4.77701 19.3426 7.68036 17.8215 10.5833 16.2997L19.3056 11.7273L20.3209 11.195L19.308 10.6602Z" fill="#FFFFFE"/>
                            </svg>
                        </a>
                        <img src="http://img.youtube.com/vi/${youtubeId}/maxresdefault.jpg" alt="video" data-youtube-link="https://www.youtube.com/embed/${youtubeId}?rel=0&#038;showinfo=0"/>
                    </div>
                `;
            }
        }

        if (resourceType === Constants.EVENT_RESOURCE_PDF) {

            let pdfSrc = Helpers.getEventResourcePdfSrc(resourceContent);
            let docsGoogleViewerUrl = Constants.DOCS_GOOGLE_VIEWER_URL;

            resourcesHtml += `
                <div class="eb-event-resource-pdf">
                    <a href="${Helpers.getImageFullUrl(resourceContent)}"
                        target="_blank" download="" class="eb-tooltip-wrap">
                        <svg width="20" height="20" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1.58203 13.6667C1.2487 13.6667 0.957031 13.5417 0.707031 13.2917C0.457031 13.0417 0.332031 12.75 0.332031 12.4167V9.43754H1.58203V12.4167H12.4154V9.43754H13.6654V12.4167C13.6654 12.75 13.5404 13.0417 13.2904 13.2917C13.0404 13.5417 12.7487 13.6667 12.4154 13.6667H1.58203ZM6.9987 10.4792L2.97786 6.45837L3.8737 5.56254L6.3737 8.06254V0.333374H7.6237V8.06254L10.1237 5.56254L11.0195 6.45837L6.9987 10.4792Z" fill="#fff"/>
                        </svg>
                        <div class="eb-custom-tooltip">
                            <div class="eb-custom-tooltip-text">Download</div>
                        </div>
                    </a>
                    
                    <iframe sandbox="allow-scripts allow-same-origin" data-resource_id="${Date.now()}"
                        data-loaded="false" 
                        data-docs_google_viewer_url="${docsGoogleViewerUrl}"
                        class="preview_pdf pdf-preview-event-details-page"
                        src="${pdfSrc}"
                        width="100%" height="300" frameborder="0">
                    </iframe>
                </div>
            `;
        }
    })

    return resourcesHtml;
}

// Initialize Google Map
function initializeGoogleMap(latitude, longitude) {
    console.log("Initializing Google Map");

    $('#map').locationpicker({
        location: {latitude, longitude},
        markerIcon: '/site/images/location_marker.png',
        radius: 0,
        enableAutocomplete: false,
        enableAutocompleteBlur: false,
        markerDraggable: false,
        zoom: 15,
        scrollwheel: false,
    });
}

// Load dependencies and initialize the map
function loadDependenciesAndInitializeMap(eventVenue) {
    let latitude = eventVenue.latitude;
    let longitude = eventVenue.longitude;

    if (!latitude || !longitude) {
        return false;
    }

    const mapKey = Config.GOOGLE_MAP_API_KEY;
    const loader = new Loader(mapKey, {
        libraries: ['places'], // Load the places library
    });

    loader.load().then(() => {
        console.log("Google Maps API loaded");
        $(document).ready(() => initializeGoogleMap(latitude, longitude));
    }).catch((error) => {
        console.error("Error loading Google Maps API:", error);
    });
}

let previewPdfIframeIntervals = [];
function initIntervalForPreviewPdf() {
    $(".preview_pdf").each(function (k, item) {
        const srcId = $(item).attr("data-resource_id");
        const isLoaded = $(item).attr("data-loaded") === "true";

        if (isLoaded) {
            return
        }

        if (srcId) {
            previewPdfIframeIntervals[srcId] = setInterval(function () {
                const isLoaded = $(item).attr("data-loaded") === "true";
                if (!isLoaded) {
                    $(item).attr("src", $(item).attr("src"));
                    console.log(`updating preview pdf src ${srcId}`)
                }
            }, 3000)
        }
    })
}

function loadedPreviewPdfIframe(_this) {
    const scrId = $(_this).attr("data-resource_id");

    if (scrId && previewPdfIframeIntervals[scrId]) {
        clearInterval(previewPdfIframeIntervals[scrId]);
        $(_this).attr("data-loaded", true);
    }
}

function getEventDescription(eventDetails, widgetConfig = {}) {
    if (!eventDetails?.description || widgetConfig?.display_event_description === false) {
        return '';
    }

    return `<h4 class="eb-section-title">About This Event</h4>
        <div class="eb-description">
            ${eventDetails?.description}
        </div>
    `;
}

function getEventLocation(eventDetails) {
    if (!eventDetails || eventDetails?.configuration?.type !== Constants.EVENT_TYPE.VENUE) {
        return '';
    }

    let eventVenue = Helpers.getEventVenue(eventDetails);

    if (Helpers.isEmptyObject(eventVenue)) {
        return '';
    }

    let eventVenueAddress = eventVenue?.address;

    let mapLink = `https://maps.google.com/?q=${eventVenue.latitude},${eventVenue.longitude}`

    return `<div class="eb-side-box eb-event-location">
        <div class="eb-event-location-desktop">
            <h4 class="eb-side-title">Event Location</h4>
            <div class="eb-location-address">
                ${eventVenue ? `<span>${eventVenue.name}</span>` : ''}
                <p>${Helpers.getEventAddress(eventVenueAddress)}</p>
            </div>  
            <a href="${mapLink}" target="_blank" class="eb-view-map-btn">View on Map</a>
        </div>
        <div class="eb-event-location-mobile">
            <h4 class="eb-side-title">Event Location</h4>
            <div class="eb-event-location-border-box">
                <div class="eb-location-icon-svg">
                    <svg width="15" height="18" viewBox="0 0 15 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_59139_197243)">
                        <path d="M14.318 7.48627C14.318 12.7807 7.49982 17.3184 7.49982 17.3184C7.49982 17.3184 0.681641 12.7807 0.681641 7.48627C0.681641 5.68105 1.39998 3.94977 2.67864 2.67329C3.9573 1.39681 5.69153 0.679687 7.49982 0.679688C9.30812 0.679688 11.0423 1.39681 12.321 2.67329C13.5997 3.94977 14.318 5.68105 14.318 7.48627Z" stroke="black" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M7.50027 9.75647C7.94977 9.75647 8.38918 9.6234 8.76293 9.3741C9.13667 9.12479 9.42798 8.77045 9.59999 8.35587C9.77201 7.94129 9.81702 7.48509 9.72932 7.04498C9.64163 6.60486 9.42517 6.20059 9.10733 5.88328C8.78948 5.56598 8.38452 5.34989 7.94365 5.26235C7.50279 5.1748 7.04582 5.21973 6.63053 5.39146C6.21524 5.56318 5.86029 5.85399 5.61056 6.2271C5.36083 6.60021 5.22754 7.03887 5.22754 7.48761C5.22754 8.08935 5.46699 8.66644 5.89321 9.09194C6.31942 9.51743 6.8975 9.75647 7.50027 9.75647Z" stroke="black" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>
                        </g>
                        <defs>
                        <clipPath id="clip0_59139_197243">
                        <rect width="15" height="18" fill="white"/>
                        </clipPath>
                        </defs>
                    </svg>
                </div>
                <div class="eb-location-address-wrap">
                    <div class="eb-location-address">
                        ${eventVenue ? `<span>${eventVenue.name}</span>` : ''}
                        <p>${Helpers.getEventAddress(eventVenueAddress)}</p>
                    </div>  
                    <a href="${mapLink}" target="_blank" class="eb-view-map-btn">View on Map</a>
                </div>
            </div>
        </div>
    </div>`;
}

export default EventDetails;
