import $ from 'jquery';
import './style.css';
import { Helpers } from '../../utils/helpers';
import {Constants} from '../../utils/constants';
import {Config} from '../../../config';


/*params
data {
    eventDetails: {
        {
            "uuid": "ac61b979-73c2-4461-9268-a10cd64c89d6",
            "organisation_uuid": "98306f0a-d672-40e9-8580-d606094cabc6",
            "name": "fsdfbsd fs",
            "url": "https://lemon.doyour.events/b/event/fsdfbsd-fs",
            "category_info": " cat- ebtyp-1",
            "thumbnail": "uploads/_default/events/banner/set1/jpg/Image=XXL.jpg",
            "cdn_banner": "https://eb-s3-rashed.s3.ap-south-1.amazonaws.com/banner/efd032f1-3fff-4051-a71a-e11559843750.webp",
            "cdn_thumbnail": "https://eb-s3-rashed.s3.ap-south-1.amazonaws.com/thumbnail/efd032f1-3fff-4051-a71a-e11559843750.webp",
            "is_cropped": false,
            "event_type": 1,
            "type_of_occurrence": 1,
            "occurrences":[
            {
                "starts_on": {
                    "utc": "2025-07-10 19:00",
                },
                "ends_on": {
                    "utc": "2025-07-10 20:00",
                }
            }
        ],
            "starts_on": {
            "utc": "2025-07-10 19:00",
        },
            "ends_on": {
            "utc": "2025-07-10 20:00",
        },
            "is_past": false,
            "is_live": false,
            "total_review": "2",
            "average_rating": "4.0",
            "rating_review": "4.0 (2)",
            "price": "$0.00",
            "currency": "USD",
            "currency_symbol": "$",
            "has_multiple_price": 1,
            "book_marked": false,
            "duration": "1h ",
            "ticket_remaining": 0,
            "has_session": false,
            "session_count": 0,
            "session_count_text": "no session",
            "enable_datetime_conversion": 1,
            "timezone": "America/Adak",
            "status": "",
            "event_status": 1,
            "created": {
            "utc": "2022-10-30 12:58",
        },
            "modified": {
            "utc": "2022-10-30 12:58",
        },
            "slug": "fsdfbsd-fs",
            "is_featured": false,
            "is_free_event": false,
            "venue": {
            "city": "",
                "state": "England",
                "country": "United Kingdom"
        },
            "tags": [],
            "categories": [],
            "listed": true/false
        }
    },
    widgetConfig: {
        {
            "organisation_uuid": "39107d3c-76b8-46a5-910b-70c89838a04f",
            "type": 2,
            "event_uuids": [
                "4af644e6-9215-4bd6-8bde-eb253f0a4696",
            ],
            "theme_colour": "#090501",
            "button_shape": 1,
            "button_text": "Details",
            "created_on": "2024-08-19T10:50:30+00:00",
            "updated_on": "2024-12-30T09:35:31+00:00"
        }
    },
    bookNowCallback: fn
}*/
function EventCard(data) {
    const eventDetails = data?.eventDetails;
    const widgetConfig = data?.widgetConfig;
    // console.log({eventDetails}, ' Event Card');
    if(!eventDetails) return null;

    let bookNowButtonText = Helpers.getWidgetButtonText(widgetConfig);
    let widgetButtonStyle = Helpers.getWidgetButtonStyle(widgetConfig);

    let imageUrl = "";
    if (eventDetails.cdn_thumbnail) {
        imageUrl = eventDetails.cdn_thumbnail;
    } else {
        imageUrl = Config.EB_BASE_URL+'/'+eventDetails.thumbnail;
    }

    let isCroppedImageClass = '';
    if (imageUrl.includes("cropped_images/landscape")) {
        isCroppedImageClass = 'eb-event-card-thumb-cropped';
    }

    const container = document.createElement('div');
    container.className = 'eb-event-card';
    container.innerHTML = `
        <div class="eb-event-card-content">
             <a href="#" class="eb-event-card-thumb ${isCroppedImageClass}">
                <img src="${imageUrl}" class="eb-event-thumb"/>
            </a>
            
            <div class="eb-event-card-meta">
                <div class="eb-card-meta-left-wrap">
                    <!--<div class="eb-card-date-wrap">
                        <div class="eb-card-date">
                            <span class="eb-card-day">25</span>
                            <span class="eb-card-month-name">Fev</span>
                        </div>
                        <span class="eb-d-none"><i class="ebi-calender-icon"></i></span>
                    </div>-->
                    
                    ${eventDetails.is_live ? `
                        <div class="eb-status-live" data-toggle="tooltip" data-original-title="Live">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="18" viewBox="0 0 24 18">
                                <g fill="#FFFFFF" fill-rule="evenodd">
                                    <ellipse cx="12" cy="8.705" rx="3" ry="3"></ellipse>
                                    <path class="on-air-out" d="M3.51471863.219669914C-1.17157288 4.90596141-1.17157288 12.5039412 3.51471863 17.1902327 3.80761184 17.4831259 4.28248558 17.4831259 4.5753788 17.1902327 4.86827202 16.8973394 4.86827202 16.4224657 4.5753788 16.1295725.474873734 12.0290674.474873734 5.38083515 4.5753788 1.28033009 4.86827202.987436867 4.86827202.512563133 4.5753788.219669914 4.28248558-.0732233047 3.80761184-.0732233047 3.51471863.219669914zM20.4852814 17.1902327C25.1715729 12.5039412 25.1715729 4.90596141 20.4852814.219669914 20.1923882-.0732233047 19.7175144-.0732233047 19.4246212.219669914 19.131728.512563133 19.131728.987436867 19.4246212 1.28033009 23.5251263 5.38083515 23.5251263 12.0290674 19.4246212 16.1295725 19.131728 16.4224657 19.131728 16.8973394 19.4246212 17.1902327 19.7175144 17.4831259 20.1923882 17.4831259 20.4852814 17.1902327z"></path>
                                    <path class="on-air-in" d="M17.3033009 14.0082521C18.7217837 12.5897693 19.4928584 10.6983839 19.4999509 8.73215792 19.507111 6.74721082 18.7352286 4.8335782 17.3033009 3.40165043 17.0104076 3.10875721 16.5355339 3.10875721 16.2426407 3.40165043 15.9497475 3.69454365 15.9497475 4.16941738 16.2426407 4.4623106 17.3890249 5.6086948 18.0056933 7.13752465 17.9999607 8.72674718 17.9942823 10.30094 17.3782748 11.8119579 16.2426407 12.947592 15.9497475 13.2404852 15.9497475 13.7153589 16.2426407 14.0082521 16.5355339 14.3011454 17.0104076 14.3011454 17.3033009 14.0082521zM6.69669914 3.40165043C3.76776695 6.33058262 3.76776695 11.07932 6.69669914 14.0082521 6.98959236 14.3011454 7.46446609 14.3011454 7.75735931 14.0082521 8.05025253 13.7153589 8.05025253 13.2404852 7.75735931 12.947592 5.41421356 10.6044462 5.41421356 6.80545635 7.75735931 4.4623106 8.05025253 4.16941738 8.05025253 3.69454365 7.75735931 3.40165043 7.46446609 3.10875721 6.98959236 3.10875721 6.69669914 3.40165043z"></path>
                                </g>
                            </svg>
                        </div>
                    ` : ``}
                </div>
                ${generateVenueHTML(eventDetails)}
            </div>
            
            <div class="eb-event-card-details">
                <div class="eb-event-status-review-block">
                
                    ${ (eventDetails?.status && eventDetails?.status !== "Tickets Remaining" && eventDetails?.status.trim() !== "") ? `
                        <span class="eb-event-status-box ${getClassForStatus(eventDetails?.status)}">${Helpers.htmlspecialchars(eventDetails?.status)}</span>
                    ` : ``}
                    
                    ${eventDetails?.status && eventDetails?.status === "Tickets Remaining" ? `
                        <span class="eb-event-status-box eb-remaining-status">${Helpers.htmlspecialchars(eventDetails?.ticket_remaining)} Remaining</span>
                    ` : ``}
                    
                    ${!Helpers.isEmpty(eventDetails.total_review) && !Helpers.isEmpty(eventDetails.average_rating) ? `
                        <span class="eb-event-review-status"><i class="ebi-star-icon"></i> ${eventDetails.rating_review}</span>
                    ` : `` }
                </div>
                <a class="eb-event-card-title clickToDetails">${Helpers.truncateString(eventDetails?.name, 100)}</a>
                <div class="eb-event-card-price">
                    ${generatePricingHTML(eventDetails)}
                </div>
                
                <div class="eb-event-card-date">
                    ${generateDateTimeHTML(eventDetails)}
                </div>
                
                <button type="button" class="eb-book-button clickToDetails" ${widgetButtonStyle}>${bookNowButtonText}</button>
            </div>
        </div>
    `;

    // Convert the container to a jQuery object
    const $container = $(container);

    // Add click event handler for the "Book Now" button
    $container.on('click', '.clickToDetails', function () {
        if(data?.bookNowCallback){
            data?.bookNowCallback(eventDetails, widgetConfig);
        }
    });

    return container;
}

function getClassForStatus(status){
    switch (status) {
        case "Sold Out":
            return "eb-sold-out-status";
        case "Event Ended":
            return "eb-ended-status";
        case "Booking Ended":
            return "eb-booking-ended-status";
        default:
            return "";
    }
}

function generateDateTimeHTML(item) {
    if (item?.type_of_occurrence && item?.type_of_occurrence === 1) {
        return `
            <div class="eb-event-card-date-time-wrap">
                ${!item?.has_session ? `
                    <span class="eb-cd-date-time">
                        <i style="font-style:normal">${Helpers.convertToVisitorDateTime(item.starts_on?.utc, item.timezone)}</i>
                    </span>
                ` : ''}
                ${item?.has_session ? `
                    <span class="eb-cd-multiple-session">Multiple Sessions</span>
                ` : ''}
                ${item?.duration && !item?.has_session ? `
                    <span class="eb-cd-duration">
                        ${item?.duration}
                    </span>
                ` : ''}
            </div>
        `;
    } else {
        return `
            <div class="eb-event-card-date-time-wrap">
                <span class="eb-cd-multiple-dates">Multiple Dates</span>
                ${item?.has_session ? `
                    <span class="eb-cd-multiple-session">Multiple Sessions</span>
                ` : ''}
            </div>
        `;
    }
}

function generateVenueHTML(item) {
    return `
        <div class="eb-event-type">
            ${item?.event_type === Constants.EVENT_TYPE_NUMBER.VENUE ? `
                <div class="eb-custom-tooltip-wrap eb-tooltip-width-auto">
                    <svg width="16" height="20" viewBox="0 0 16 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7.91745 0C5.81824 0.00203201 3.80558 0.836882 2.32121 2.32125C0.836842 3.80562 0.00203201 5.81824 0 7.91746C0.00440171 9.34719 0.441708 10.742 1.25434 11.9184L7.45584 19.7492C7.50554 19.8262 7.57373 19.8895 7.65417 19.9333C7.73462 19.9771 7.82476 20 7.91635 20C8.00795 20 8.09809 19.9771 8.17853 19.9333C8.25898 19.8895 8.32716 19.8262 8.37686 19.7492L14.5795 11.9173C15.3923 10.7415 15.8297 9.34689 15.8338 7.91746C15.8318 5.81843 14.9971 3.80592 13.513 2.32159C12.0288 0.837248 10.0165 0.00232223 7.91745 0ZM7.91745 1.09645C8.8141 1.09529 9.70216 1.27109 10.5308 1.61369C11.3594 1.95629 12.1123 2.45897 12.7463 3.09299C13.3803 3.72702 13.883 4.47989 14.2256 5.30851C14.5682 6.13713 14.744 7.02523 14.7428 7.92188C14.7484 9.1447 14.3694 10.3383 13.6595 11.334L7.91745 18.4477L2.17535 11.3285C1.46744 10.3325 1.09006 9.13939 1.09645 7.91746C1.09529 7.02118 1.27091 6.13349 1.61323 5.30516C1.95556 4.47683 2.45787 3.72415 3.09143 3.09018C3.725 2.45622 4.47736 1.9534 5.30547 1.61054C6.13358 1.26768 7.02117 1.09152 7.91745 1.0921V1.09645ZM7.91745 3.82659C7.10749 3.82659 6.31572 4.06683 5.64226 4.51682C4.9688 4.96681 4.44391 5.60639 4.13395 6.3547C3.82399 7.10301 3.74289 7.92639 3.90091 8.72079C4.05892 9.51519 4.44895 10.2449 5.02168 10.8177C5.59441 11.3904 6.32411 11.7804 7.11851 11.9384C7.91291 12.0964 8.73632 12.0153 9.48463 11.7054C10.2329 11.3954 10.8725 10.8705 11.3225 10.197C11.7725 9.52356 12.0127 8.73184 12.0127 7.92188C12.0118 6.83562 11.5802 5.79401 10.8125 5.0255C10.0448 4.25698 9.00371 3.82427 7.91745 3.82224V3.82659ZM7.91745 4.92304C8.51142 4.92304 9.09205 5.09918 9.58592 5.42917C10.0798 5.75916 10.4647 6.22822 10.692 6.77698C10.9193 7.32573 10.9788 7.92957 10.8629 8.51213C10.747 9.09468 10.461 9.62979 10.041 10.0498C9.62101 10.4698 9.0859 10.7558 8.50334 10.8717C7.92078 10.9876 7.31694 10.9281 6.76819 10.7008C6.21943 10.4735 5.7504 10.0886 5.42041 9.59472C5.09041 9.10085 4.91428 8.5202 4.91428 7.92623C4.91196 7.53078 4.98799 7.13879 5.13799 6.77289C5.28798 6.40699 5.50896 6.07446 5.78818 5.79443C6.0674 5.5144 6.39932 5.2924 6.76478 5.14134C7.13024 4.99028 7.522 4.91311 7.91745 4.91427V4.92304Z" fill="white"></path>
                    </svg>
                    <span>${item?.venue?.city || ''}</span>
                    <div class="eb-custom-tooltip-title eb-tooltip-venue">Venue Event</div>
                </div>
            ` : ''}
            
            ${item?.event_type === Constants.EVENT_TYPE_NUMBER.UNDECIDED ? `
                <div class="eb-custom-tooltip-wrap eb-tooltip-width-auto">
                    <svg width="15" height="19" viewBox="0 0 15 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7.125 0C3.19141 0 0 3.22852 0 7.125C0 9.98242 0.927734 10.8359 6.38281 18.666C6.56836 18.8887 6.82812 19 7.125 19C7.38477 19 7.64453 18.8887 7.83008 18.666C13.2852 10.8359 14.25 9.98242 14.25 7.125C14.25 3.22852 11.0215 0 7.125 0ZM7.125 16.5879C6.56836 15.8086 6.08594 15.1035 5.64062 14.5098C2.15234 9.53711 1.78125 8.94336 1.78125 7.125C1.78125 4.19336 4.15625 1.78125 7.125 1.78125C10.0566 1.78125 12.4688 4.19336 12.4688 7.125C12.4688 8.94336 12.0605 9.53711 8.57227 14.5098C8.12695 15.1035 7.64453 15.8086 7.125 16.5879ZM7.19922 3.26562C5.64062 3.26562 4.3418 4.37891 4.00781 5.82617C3.93359 6.19727 4.23047 6.53125 4.60156 6.53125H5.23242C5.49219 6.53125 5.71484 6.38281 5.78906 6.12305C5.97461 5.49219 6.53125 5.04688 7.19922 5.04688C8.16406 5.04688 8.68359 5.82617 8.68359 6.53125C8.68359 7.125 7.94141 7.57031 6.82812 8.12695C6.49414 8.27539 6.30859 8.57227 6.30859 8.90625V9.53711C6.30859 9.83398 6.56836 10.0938 6.90234 10.0938H7.49609C7.83008 10.0938 8.08984 9.83398 8.08984 9.53711V9.46289C9.24023 8.86914 10.4648 8.05273 10.4648 6.53125C10.4648 4.93555 9.24023 3.26562 7.19922 3.26562ZM7.125 10.6875C6.45703 10.6875 5.9375 11.2441 5.9375 11.875C5.9375 12.543 6.45703 13.0625 7.125 13.0625C7.75586 13.0625 8.3125 12.543 8.3125 11.875C8.3125 11.2441 7.75586 10.6875 7.125 10.6875Z" fill="white"></path>
                    </svg>
                    <div class="eb-custom-tooltip-title eb-tooltip-to-be-announced">To Be Announced</div>
                </div>
            ` : ''}

            ${item?.event_type === Constants.EVENT_TYPE_NUMBER.VIRTUAL ? `
                <div class="eb-custom-tooltip-wrap eb-tooltip-width-auto">
                    <i class="ebi-video-icon" data-toggle="tooltip" data-placement="top" data-original-title=""></i>
                    <div class="eb-custom-tooltip-title eb-tooltip-online-event">Online Event</div>
                </div>
            ` : ''}
        </div>
    `;
}


function generatePricingHTML(item) {
    return `
        <div class="eb-event-card-price-inner">
            ${item?.pricing?.is_free ? `
                <span>Free</span>
            ` : `
                <span>${item?.currency}</span>
                ${item?.pricing?.has_discount && !Helpers.isEmpty(item?.pricing?.discounted_price) ? `
                    <del class="eb-del-price">${item?.pricing?.actual_price}</del>
                    <span class="eb-discounted-price">${item?.pricing?.discounted_price}</span>
                ` : `
                    <span class="font-14 font-Semibold">${item?.pricing?.actual_price}</span>
                `}
            `}
            
            ${item?.has_multiple_price ? `
                <div class="eb-custom-tooltip-wrap">
                    <span class="eb-custom-tooltip-btn">*</span>
                    <div class="eb-custom-tooltip-title">Multiple Tickets</div>
                </div>
<!--                <span class="font-16 cursor-pointer btn-tol-abs" data-toggle="tooltip" data-placement="top" title="" data-original-title="Multiple Tickets"> *</span>-->
            ` : ''}
        </div>
    `;
}

export default EventCard;
