import $ from 'jquery';
import '../../../icon-fonts/style.css';
import '../../../css/style.css';
import {Helpers} from '../../utils/helpers';
import {Components} from "../../utils/component";


let c_date = new Date();
let day = c_date.getDay();
let month = c_date.getMonth();
let year = c_date.getFullYear();

function ButtonTypeWidget(data) {
    const eventDetails = data?.eventDetails;
    if (!eventDetails) return null;

    const widgetConfig = data?.widgetConfig;
    const bookNowCallback = data?.bookNowCallback;

    window.eventDetails = eventDetails;
    window.widgetConfig = widgetConfig;
    window.bookNowCallback = bookNowCallback;

    let bookNowButtonText = Helpers.getWidgetButtonText(widgetConfig, "Buy Tickets ");
    let widgetButtonStyle = Helpers.getWidgetButtonStyle(widgetConfig);

    const container = document.createElement('div');
    // container.className = 'event-card';
    container.innerHTML = `
        <div class="">
            <button onclick="Components.openEventTicketPopup(eventDetails)" id="ebBuyTickets" class="eb-btn-black" ${widgetButtonStyle}>
                ${bookNowButtonText}          
            </button>
        </div>
        
        <!--Modal-->
        ${Components.getTicketPopup(eventDetails, widgetConfig)}
    `;

    // Convert the container to a jQuery object
    const $container = $(container);

    let timeslotList = null;
    let eventDateListData = null;
    let bookedEventDateListData = null;
    let bookedEventDateList = null;

    $(document).ready(function () {
        Helpers.initializeSelect2Picker();

        let isRecurringEvent = Helpers.isRecurringEvent(eventDetails);
        let hasEventSessionForSell = Helpers.hasEventSessionForSell(eventDetails);

        if (isRecurringEvent && !hasEventSessionForSell) {
            Helpers.triggerChangeOccurrencePicker();
        }

        if(hasEventSessionForSell){
            let occurrenceUUID = '';
            if(isRecurringEvent){
                occurrenceUUID = Helpers.getSelectedOccurrenceUuid();

                $('.occSubBtn').attr('onclick', `TicketValidation.submitTicketForm("${occurrenceUUID}")`);

                $('.backToSessionListFromTicketList').attr('onclick', `TicketValidation.showEventSessionList("${occurrenceUUID}")`);
                $('.addAnotherSession').attr('onclick', `TicketValidation.showEventSessionList("${occurrenceUUID}")`);
            }
            
            $('.popupSessionList_'+occurrenceUUID).removeClass('eb-d-none');
        }

        //Initialized donation ticket
        Helpers.initSliderContainer();//Initialized timeslot
        ({
            month,
            year,
            timeslotList,
            eventDateListData,
            bookedEventDateListData,
            bookedEventDateList
        } = Helpers.initTimeslotContainer(eventDetails));

    }).on('click', '.prevMonth', function(){
        year = (month === 0) ? year - 1 : year;
        month = (month === 0) ? 11 : month - 1;
        Helpers.renderSellAppointmentCalendar(month, year, eventDateListData, bookedEventDateList, bookedEventDateListData);
    }).on('click', '.eb_time_slots', function(){
        $('.eb_time_slots').removeClass('active');
        $(this).addClass('active');
    }).on('click', '.nextMonth', function(){
        year = (month === 11) ? year + 1 : year;
        month = (month + 1) % 12;
        Helpers.renderSellAppointmentCalendar(month, year, eventDateListData, bookedEventDateList, bookedEventDateListData);
    }).on('click', '.show_event', function(){
        $('.show_event').removeClass('active');
        $('#event').removeClass('d-none');
        $(this).addClass('active');
        let selectedOccurrenceUUID = $(this).attr('data-occurrence_uuid');
        Helpers.showAppointmentTimeslots(eventDetails, timeslotList, eventDateListData, false, selectedOccurrenceUUID);
        Helpers.autoSelectFirstAvailableTimeSlot();
    });

    return container;
}

export default ButtonTypeWidget;
