# EventBookings JavaScript Build Guide

## Build Scripts

### Production Build (Default)
```bash
npm run build
```
- **Purpose**: Production-ready bundle for deployment
- **Mode**: `production`
- **Minification**: Enabled
- **Source Maps**: Disabled (for security)
- **Watch**: Disabled
- **Output**: `dist/component-bundle.js`

### Development Build
```bash
npm run build:dev
```
- **Purpose**: Development bundle with debugging support
- **Mode**: `development`
- **Minification**: Disabled
- **Source Maps**: Enabled (`component-bundle.js.map`)
- **Watch**: Disabled
- **Output**: `dist/component-bundle.js` + `dist/component-bundle.js.map`

### Watch Mode (Development)
```bash
npm run watch
```
- **Purpose**: Auto-rebuild on file changes during development
- **Mode**: `development`
- **Minification**: Disabled
- **Source Maps**: Enabled
- **Watch**: Enabled (auto-recompile on save)
- **Output**: `dist/component-bundle.js` + `dist/component-bundle.js.map`

## Source Map Configuration

Source maps are **conditionally generated** based on `NODE_ENV`:

- **Production** (`NODE_ENV=production`): Source maps disabled (`devtool: false`)
- **Development** (`NODE_ENV=development`): Source maps enabled (`devtool: 'source-map'`)

### Why Disable Source Maps in Production?

1. **Security**: Prevents exposure of original source code structure
2. **File Size**: Reduces deployment bundle size (no .map files)
3. **Performance**: Faster browser loading (no map file downloads)
4. **Professional**: Production builds should be optimized and minified

## Development Workflow

### Initial Setup
```bash
npm install
```

### During Development
```bash
npm run watch
```
- Edit files in `src/`
- Webpack auto-recompiles on save
- Source maps available for debugging in browser DevTools

### Before Deployment
```bash
npm run build
```
- Creates optimized production bundle
- No source maps included
- Minified and ready for WordPress plugin deployment

## File Output

### Production Build
```
dist/
├── component-bundle.js           # Minified bundle (2.87 MB)
├── component-bundle.js.LICENSE.txt
└── images/                       # Asset images
```

### Development Build
```
dist/
├── component-bundle.js           # Unminified bundle with source references
├── component-bundle.js.map       # Source map for debugging
├── component-bundle.js.LICENSE.txt
└── images/                       # Asset images
```

## Troubleshooting

### Source Maps Appearing in Production
**Issue**: `.map` files generated during production build
**Solution**: Ensure `NODE_ENV=production` is set
```bash
npm run build  # Uses cross-env to set NODE_ENV automatically
```

### Build Errors
**Issue**: Module not found or dependency errors
**Solution**: Reinstall dependencies
```bash
rm -rf node_modules package-lock.json
npm install
```

### Watch Mode Not Working
**Issue**: Files changed but webpack not recompiling
**Solution**: Restart watch mode
```bash
# Press Ctrl+C to stop
npm run watch
```

## Configuration Files

- **webpack.config.js**: Build configuration with conditional source maps
- **package.json**: NPM scripts and dependencies
- **.babelrc** (if exists): JavaScript transpilation settings

## Environment Variables

| Variable | Values | Effect |
|----------|--------|--------|
| `NODE_ENV` | `production` | Minified, no source maps, no watch |
| `NODE_ENV` | `development` | Unminified, source maps, watch enabled |

Scripts automatically set `NODE_ENV` via `cross-env` for cross-platform compatibility (Windows/Mac/Linux).
