<?php

class EVENTBOOKINGS_Plugin
{
    private $settings;
    private $shortcode;

    public function __construct()
    {
        $this->eventbookings_includes();

        function eventbookings_admin_styles()
        {
            wp_enqueue_style('eventbookings-admin-custom-style', plugin_dir_url(__FILE__) . 'css/admin-style.css', array(), '1.1', 'all');

            wp_enqueue_script(
                'eventbookings-admin-js',
                plugin_dir_url(__FILE__) . 'js/settings.js',
                array('jquery'),
                '1.1',
                true
            );

            wp_localize_script('eventbookings-admin-js', 'eventbookings_wp_global_object', array(
                'ajax_url' => admin_url('admin-ajax.php'),
                'nonce' => wp_create_nonce('eventbookings_admin_nonce'),
            ));
        }

        add_action('admin_enqueue_scripts', 'eventbookings_admin_styles');

        // Instantiate required classes
        $this->settings = new Eventbookings_Settings();
        $this->shortcode = new Eventbookings_Plugin_Shortcode();

        // Hook actions correctly
        add_action('admin_menu', array($this->settings, 'eventbookings_add_admin_menu'));
        add_action('init', array($this->shortcode, 'eventbookings_register_shortcode'));
    }

    private function eventbookings_includes()
    {
        if (!defined('EVENTBOOKINGS_PLUGIN_PATH')) {
            define('EVENTBOOKINGS_PLUGIN_PATH', plugin_dir_path(__FILE__));
        }
        require_once EVENTBOOKINGS_PLUGIN_PATH . 'includes/class-eventbookings-settings.php';
        require_once EVENTBOOKINGS_PLUGIN_PATH . 'includes/class-eventbookings-api.php';
        require_once EVENTBOOKINGS_PLUGIN_PATH . 'includes/class-eventbookings-shortcode.php';
    }
}
