<?php

class Eventbookings_Customized_Events
{
    private $table;

    public function __construct()
    {
        global $wpdb;
        $this->table = $wpdb->prefix . 'customized_events';
    }

    public function eventbookings_insert_event_settings($data)
    {
        global $wpdb;
        return $wpdb->insert(
            $this->table,
            [
                'organisation_uuid' => $data['organisation_uuid'],
                'display_event_description' => $data['display_event_description'] ?? 1,
                'display_countdown' => $data['display_countdown'] ?? 1,
                'display_booking_start_countdown' => $data['display_booking_start_countdown'] ?? 1,
                'display_discount_end_countdown' => $data['display_discount_end_countdown'] ?? 1,
                'display_event_start_countdown' => $data['display_event_start_countdown'] ?? 1,
                'display_event_end_countdown' => $data['display_event_end_countdown'] ?? 1,
                'display_event_location_map' => $data['display_event_location_map'] ?? 1,
                'display_ticket_price_on_event_page' => $data['display_ticket_price_on_event_page'] ?? 1,
                'display_terms_and_condition' => $data['display_terms_and_condition'] ?? 1,
            ],
            ['%s', '%d', '%d', '%d', '%d', '%d', '%d', '%d', '%d', '%d']
        );
    }

    public function eventbookings_get_event_settings($organisation_uuid)
    {
        global $wpdb;
        return $wpdb->get_row($wpdb->prepare(
            "SELECT * FROM $this->table WHERE organisation_uuid = %s",
            $organisation_uuid
        ), ARRAY_A);
    }

    public function eventbookings_update_event_settings($organisation_uuid, $data)
    {
        global $wpdb;
        return $wpdb->update(
            $this->table,
            $data,
            ['organisation_uuid' => $organisation_uuid],
            ['%d', '%d', '%d', '%d', '%d', '%d', '%d', '%d', '%d'],
            ['%s']
        );
    }
}
