# EventBookings Plugin User Manual

Complete user guide for WordPress administrators and end-users working with the EventBookings plugin.

## Table of Contents

1. [Getting Started](#getting-started)
2. [Plugin Installation](#plugin-installation)
3. [Initial Setup and Configuration](#initial-setup-and-configuration)
4. [Admin Dashboard](#admin-dashboard)
5. [Adding Events to Your Website](#adding-events-to-your-website)
6. [Customizing Event Display](#customizing-event-display)
7. [Troubleshooting](#troubleshooting)
8. [Frequently Asked Questions](#frequently-asked-questions)
9. [Support and Resources](#support-and-resources)

## Getting Started

### What is EventBookings Plugin?

The EventBookings plugin allows you to seamlessly integrate your EventBookings events with your WordPress website. Display events, handle bookings, and manage event settings directly from your WordPress admin dashboard.

### Key Features

- **Event Display**: Show your events in attractive, responsive layouts
- **Featured Events**: Highlight specific events in carousel format
- **Booking Integration**: Allow visitors to book tickets directly from your website
- **Customizable Display**: Control which event information is shown
- **Mobile Responsive**: Optimized for all device sizes
- **SEO Friendly**: Events are indexed by search engines

### Prerequisites

Before starting, you'll need:
- A WordPress website (version 5.0 or higher)
- An EventBookings account with API access
- Client ID and Client Secret from EventBookings
- Administrator access to your WordPress dashboard

## Plugin Installation

### Method 1: Upload via WordPress Admin

1. **Download the Plugin**: Get the `eventbookings.zip` file
2. **Access WordPress Admin**: Log into your WordPress dashboard
3. **Navigate to Plugins**: Go to **Plugins > Add New**
4. **Upload Plugin**: Click **Upload Plugin** button
5. **Choose File**: Select the `eventbookings.zip` file
6. **Install**: Click **Install Now**
7. **Activate**: Click **Activate Plugin**

### Method 2: FTP Upload

1. **Extract Files**: Unzip the plugin file on your computer
2. **Connect via FTP**: Use your FTP client to connect to your website
3. **Upload Files**: Upload the `eventbookings` folder to `/wp-content/plugins/`
4. **Activate**: In WordPress admin, go to **Plugins** and activate EventBookings

### Verification

After installation, you should see:
- "EventBookings" in your WordPress admin menu
- A green checkmark next to the plugin in the Plugins list
- No error messages on your website

## Initial Setup and Configuration

### Step 1: Get Your API Credentials

1. **Log into EventBookings**: Visit your EventBookings dashboard
2. **Create Application**: Follow this guide: [How to Create an Application for EventBookings](https://support.eventbookings.com/how-to-create-an-application-for-eventbookings/)
3. **Copy Credentials**: Save your Client ID and Client Secret

### Step 2: Configure the Plugin

1. **Open Settings**: In WordPress admin, click **EventBookings > Settings**
2. **Enter Credentials**:
   - Paste your **Client ID** in the first field
   - Paste your **Client Secret** in the second field
3. **Connect**: Click the **Connect** button
4. **Verify Connection**: You should see a success message

### Step 3: Test the Connection

After connecting successfully, you'll see:
- Connection status showing "Connected"
- Available shortcodes displayed
- Customization options become available

## Admin Dashboard

### Main Menu: EventBookings

The plugin adds a new menu item "EventBookings" to your WordPress admin with two sub-pages:

#### Events Page

**Location**: EventBookings > Events

**Purpose**: View and manage your events

**Features**:
- List of all synchronized events
- Event status indicators
- Quick access to event management

#### Settings Page

**Location**: EventBookings > Settings

**Purpose**: Configure plugin settings and connection

**Sections**:
1. **Connection Settings**: API credentials and connection status
2. **Shortcodes**: Copy-ready shortcodes for your pages
3. **Display Customization**: Control what information appears on events

### Connection Settings Section

#### Client ID Field
- **Purpose**: Your unique application identifier from EventBookings
- **Format**: Usually a long alphanumeric string
- **Status**: Disabled after successful connection

#### Client Secret Field
- **Purpose**: Your secret key for API authentication
- **Security**: Keep this private and secure
- **Status**: Disabled after successful connection

#### Connection Actions
- **Connect Button**: Establishes connection with EventBookings API
- **Disconnect Button**: Removes stored credentials and disconnects

### Shortcodes Section

After successful connection, you'll see three ready-to-use shortcodes:

#### Events Shortcode
```
[eventbookings_events_shortcode]
```
- **Purpose**: Display all your public events
- **Layout**: Grid layout with pagination
- **Features**: Event cards with booking buttons

#### Featured Events Shortcode
```
[eventbookings_feature_events_shortcode]
```
- **Purpose**: Display featured events in a carousel
- **Layout**: Sliding carousel with navigation
- **Features**: Highlight special events

#### Event Details Shortcode
```
[eventbookings_feature_event_details]
```
- **Purpose**: Display detailed event information
- **Usage**: Automatically created page for event details
- **Features**: Complete event information with booking

### Display Customization Section

Control which elements appear on your events:

#### Event Description
- **Option**: Display Event Description
- **Effect**: Shows/hides the full event description text
- **Recommendation**: Keep enabled for better user information

#### Countdown Timers
- **Booking Start Countdown**: Shows time until booking opens
- **Early Bird Discount Countdown**: Shows time until discount expires
- **Event Start Countdown**: Shows time until event begins
- **Event End Countdown**: Shows time until event ends

#### Location and Pricing
- **Event Location Map**: Shows/hides Google Maps integration
- **Ticket Price**: Shows/hides pricing information on event pages

#### Terms and Conditions
- **Display Terms**: Shows/hides terms and conditions
- **Recommendation**: Keep enabled for legal protection

## Adding Events to Your Website

### Method 1: Using Shortcodes

#### Step 1: Create or Edit a Page
1. Go to **Pages > Add New** or edit existing page
2. Choose where you want events to appear
3. Add one of the shortcodes

#### Step 2: Add Events List
```
[eventbookings_events_shortcode]
```

**Result**:
- Grid of event cards
- Pagination for multiple events
- "Book Now" buttons
- Responsive design

#### Step 3: Add Featured Events Carousel
```
[eventbookings_feature_events_shortcode]
```

**Result**:
- Sliding carousel of featured events
- Navigation arrows and dots
- Auto-play functionality
- Touch/swipe support on mobile

### Method 2: Using WordPress Blocks (Gutenberg)

1. **Add Shortcode Block**: Click the "+" button and search for "Shortcode"
2. **Paste Shortcode**: Add your chosen shortcode
3. **Preview**: Use the preview to see how it looks
4. **Publish**: Save or update your page

### Method 3: Using Classic Editor

1. **Switch to Text Mode**: Click the "Text" tab in the editor
2. **Add Shortcode**: Paste the shortcode where you want events
3. **Return to Visual**: Click "Visual" tab to see the result
4. **Publish**: Save your page

### Event Details Page

The plugin automatically creates an "Event Details" page:

- **URL**: `your-site.com/eb-event-details/`
- **Purpose**: Shows complete event information when visitors click event cards
- **Content**: Uses `[eventbookings_feature_event_details]` shortcode
- **Customization**: Can be edited like any WordPress page

## Customizing Event Display

### Available Customization Options

#### Content Display Options

1. **Event Description**
   - **What it shows**: Full event description text
   - **When to use**: Always recommended for user information
   - **SEO benefit**: Helps with search engine indexing

2. **Countdown Timers**
   - **Booking Start**: Creates urgency for when booking opens
   - **Early Bird Discount**: Encourages early purchases
   - **Event Start**: Builds anticipation for upcoming events
   - **Event End**: Shows urgency for ongoing events

3. **Location Information**
   - **Event Location Map**: Interactive Google Map
   - **Benefits**: Helps visitors find the venue
   - **Note**: Requires events to have address information

4. **Pricing Display**
   - **Ticket Price**: Shows pricing on event cards
   - **Benefits**: Transparency for visitors
   - **Note**: Shows lowest available price if multiple ticket types

5. **Legal Information**
   - **Terms and Conditions**: Shows important legal text
   - **Recommendation**: Always keep enabled
   - **Customization**: Content comes from EventBookings account

### Best Practices for Display Settings

#### For Maximum Engagement
Enable:
- ✅ Event Description
- ✅ Event Start Countdown
- ✅ Event Location Map
- ✅ Ticket Price
- ✅ Terms and Conditions

#### For Minimal Display
Enable only:
- ✅ Event Description
- ✅ Terms and Conditions
- ❌ All countdown timers
- ❌ Location map
- ❌ Ticket price

#### For Sales-Focused Display
Enable:
- ✅ Event Description
- ✅ Early Bird Discount Countdown
- ✅ Event Start Countdown
- ✅ Ticket Price
- ✅ Terms and Conditions

### Applying Customization Changes

1. **Make Changes**: Check/uncheck desired options in Settings
2. **Save Settings**: Click **Save Settings** button
3. **Verify Changes**: Visit your events page to see the updates
4. **Clear Cache**: If using caching plugins, clear cache to see changes

### CSS Customization

For advanced users, you can customize the appearance using CSS:

#### Common Customizations

**Change Event Card Colors**:
```css
.eb-event-card {
    background-color: #your-color;
    border: 1px solid #your-border-color;
}
```

**Customize Button Appearance**:
```css
.eb-book-now-button {
    background-color: #your-button-color;
    color: #your-text-color;
    border-radius: 5px;
}
```

**Modify Typography**:
```css
.eb-event-title {
    font-family: 'Your Font', sans-serif;
    font-size: 18px;
    font-weight: bold;
}
```

**Responsive Adjustments**:
```css
@media (max-width: 768px) {
    .eb-event-card {
        margin-bottom: 20px;
    }
}
```

Add custom CSS in:
- **WordPress Customizer**: Appearance > Customize > Additional CSS
- **Theme Files**: style.css in your active theme
- **Plugin**: Using a custom CSS plugin

## Troubleshooting

### Common Issues and Solutions

#### Issue: "Plugin doesn't appear after activation"
**Symptoms**: No EventBookings menu in admin
**Solutions**:
1. Check you have administrator privileges
2. Deactivate and reactivate the plugin
3. Clear any caching plugins
4. Check for PHP errors in debug logs

#### Issue: "Connection failed" when entering credentials
**Symptoms**: Error message when clicking Connect
**Solutions**:
1. **Verify credentials**: Double-check Client ID and Client Secret
2. **Check internet connection**: Ensure your server can reach EventBookings API
3. **Test credentials**: Use them directly in EventBookings to verify they work
4. **Contact support**: If credentials are correct but connection fails

#### Issue: "No events showing" after successful connection
**Symptoms**: Shortcode displays but no events appear
**Solutions**:
1. **Check event status**: Ensure events are published in EventBookings
2. **Verify organization**: Confirm events belong to the connected organization
3. **Clear cache**: Clear WordPress cache and browser cache
4. **Check display settings**: Ensure events aren't filtered out

#### Issue: Events display but booking doesn't work
**Symptoms**: Event cards show but "Book Now" button fails
**Solutions**:
1. **Check event booking settings**: Verify booking is enabled in EventBookings
2. **Test direct booking**: Try booking through EventBookings directly
3. **Browser console**: Check for JavaScript errors
4. **Payment gateway**: Ensure payment processing is configured

#### Issue: Events look broken or unstyled
**Symptoms**: Events display without proper formatting
**Solutions**:
1. **CSS conflicts**: Check for theme conflicts with plugin styles
2. **Clear cache**: Clear all caching plugins
3. **Browser cache**: Hard refresh (Ctrl+F5 or Cmd+Shift+R)
4. **Theme compatibility**: Test with a default WordPress theme

#### Issue: Page loading slowly with events
**Symptoms**: Pages with events take long to load
**Solutions**:
1. **Enable caching**: Use WordPress caching plugins
2. **Optimize images**: Ensure event images are properly sized
3. **Reduce displayed events**: Limit events per page if possible
4. **Server resources**: Check hosting provider for performance issues

### Error Messages and Meanings

#### "Invalid nonce"
**Meaning**: Security check failed
**Solution**: Refresh the page and try again

#### "Invalid or missing access token"
**Meaning**: Authentication credentials are invalid
**Solution**: Reconnect in Settings > Connection Settings

#### "No events found or API error"
**Meaning**: API request failed or no events match criteria
**Solutions**: Check internet connection, verify events exist in EventBookings

#### "Order data is required"
**Meaning**: Booking form data is incomplete
**Solution**: Ensure all required booking fields are filled

### Getting Debug Information

#### Enable WordPress Debug Mode
Add to `wp-config.php`:
```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
define('WP_DEBUG_DISPLAY', false);
```

#### Check Debug Logs
- **Location**: `/wp-content/debug.log`
- **Look for**: Lines containing "EventBookings"
- **Share with support**: Include relevant log entries when reporting issues

#### Browser Developer Tools
1. **Open Developer Tools**: Press F12 in your browser
2. **Console Tab**: Look for JavaScript errors
3. **Network Tab**: Check for failed API requests
4. **Elements Tab**: Inspect HTML structure if styling issues

## Frequently Asked Questions

### General Questions

#### Q: Is the plugin free to use?
**A**: The plugin is free, but you need an EventBookings account to use it. EventBookings has various pricing plans.

#### Q: Can I use this plugin with any WordPress theme?
**A**: Yes, the plugin is designed to work with any properly coded WordPress theme. Some minor styling adjustments might be needed.

#### Q: Does the plugin affect my website's loading speed?
**A**: The plugin uses caching to minimize impact. However, like any plugin that displays external content, it may slightly affect loading times.

#### Q: Can I display events from multiple EventBookings organizations?
**A**: No, each plugin installation connects to one EventBookings organization. You'd need separate WordPress sites for multiple organizations.

### Setup and Configuration

#### Q: How do I get Client ID and Client Secret?
**A**: Follow the detailed guide at [How to Create an Application for EventBookings](https://support.eventbookings.com/how-to-create-an-application-for-eventbookings/)

#### Q: What happens if I change my EventBookings password?
**A**: Password changes don't affect the plugin connection as it uses API credentials, not your login credentials.

#### Q: Can I use the plugin on a staging/development site?
**A**: Yes, you can connect to development, staging, or production EventBookings environments.

#### Q: How often does the plugin sync with EventBookings?
**A**: The plugin fetches fresh data for each page load, with caching to improve performance.

### Display and Customization

#### Q: Can I customize the appearance of events?
**A**: Yes, you can:
- Use the built-in display options in Settings
- Add custom CSS for styling
- Modify templates (advanced users)

#### Q: Can I show only certain events?
**A**: Currently, the plugin shows all published events from your organization. Event filtering features may be added in future versions.

#### Q: How do I change the number of events displayed per page?
**A**: This is currently fixed at 6 events per page for regular events and 16 for featured events. Contact support for customization options.

#### Q: Can I translate the plugin to my language?
**A**: The plugin includes translation hooks. You can create translation files or use translation plugins.

### Booking and Payments

#### Q: Do customers leave my website when booking?
**A**: Customers are redirected to secure EventBookings payment pages for booking completion, then can return to your site.

#### Q: Can I customize the booking process?
**A**: The booking flow follows EventBookings' standard process. Customization options are available through your EventBookings account settings.

#### Q: What payment methods are supported?
**A**: Payment methods depend on your EventBookings account configuration, typically including credit cards, PayPal, and other gateways.

#### Q: Do I get booking notifications?
**A**: Notifications are handled by EventBookings and sent according to your account settings.

### Technical Questions

#### Q: What PHP version is required?
**A**: PHP 7.4 or higher is recommended. The plugin may work on earlier versions but isn't tested or supported.

#### Q: Does the plugin work with caching plugins?
**A**: Yes, but you may need to clear cache after making changes. Popular caching plugins are compatible.

#### Q: Can I use the plugin with WooCommerce?
**A**: The plugin works alongside WooCommerce but doesn't integrate with it. Events are processed through EventBookings, not WooCommerce.

#### Q: Is the plugin compatible with page builders?
**A**: Yes, shortcodes work with popular page builders like Elementor, Beaver Builder, and Divi.

## Support and Resources

### Official Resources

#### EventBookings Support
- **Website**: [EventBookings Support Center](https://support.eventbookings.com)
- **Documentation**: [API Documentation](https://support.eventbookings.com/api-documentation/)
- **Application Setup**: [How to Create an Application](https://support.eventbookings.com/how-to-create-an-application-for-eventbookings/)

#### WordPress Resources
- **Codex**: [WordPress Plugin Documentation](https://codex.wordpress.org/Plugins)
- **Support**: [WordPress.org Support Forums](https://wordpress.org/support/)

### Getting Help

#### Before Contacting Support

1. **Check this manual**: Review relevant sections for your issue
2. **Search existing tickets**: Check if others have reported similar issues
3. **Test with default theme**: Temporarily switch to a default WordPress theme
4. **Disable other plugins**: Check for plugin conflicts
5. **Clear cache**: Clear all caching plugins and browser cache
6. **Gather information**: Note your WordPress version, theme, and any error messages

#### Information to Include in Support Requests

- WordPress version
- Plugin version
- Active theme name
- List of active plugins
- Detailed description of the issue
- Steps to reproduce the problem
- Screenshots or screen recordings
- Error messages from debug logs
- Browser and device information

#### Support Channels

For plugin-specific issues:
1. **Plugin Documentation**: Check this manual and API reference
2. **WordPress Forums**: Search for similar issues
3. **Theme Support**: Contact theme developer for styling conflicts
4. **EventBookings Support**: For API or booking-related issues

### Community Resources

#### WordPress Community
- **WordPress.org Forums**: General WordPress support
- **Local WordPress Meetups**: Connect with local developers
- **WordCamp Events**: WordPress conferences and learning events

#### Learning Resources
- **WordPress Codex**: Official WordPress documentation
- **WordPress TV**: Video tutorials and presentations
- **WordPress Blogs**: Stay updated with WordPress news and tutorials

### Professional Services

If you need additional customization or support:

#### WordPress Developers
- Custom theme integration
- Advanced styling and layout modifications
- Performance optimization
- Custom functionality development

#### EventBookings Partners
- Advanced event management setup
- Custom booking flows
- Integration with other systems
- Training and consultation

---

This user manual provides comprehensive guidance for successfully using the EventBookings WordPress plugin. Keep this document accessible for reference, and don't hesitate to reach out for support when needed.