# EventBookings WordPress Plugin

A comprehensive WordPress plugin for integrating EventBookings event management system with your WordPress website. Display events, handle bookings, and manage event data seamlessly.

## Overview

The EventBookings plugin provides a complete event management solution for WordPress websites, allowing you to:

- Display public events using customizable shortcodes
- Feature specific events with carousel display
- Handle event bookings and ticket purchases
- Manage event display settings through admin interface
- Integrate with EventBookings API for real-time event data

## Quick Start

### Installation

1. Upload the plugin files to the `/wp-content/plugins/eventbookings/` directory
2. Activate the plugin through the 'Plugins' screen in WordPress
3. Navigate to **EventBookings > Settings** in your WordPress admin
4. Configure your API credentials (Client ID and Client Secret)

### Basic Usage

#### Display Public Events
```php
[eventbookings_events_shortcode]
```

#### Display Featured Events
```php
[eventbookings_feature_events_shortcode]
```

#### Display Event Details Page
```php
[eventbookings_feature_event_details]
```

### Configuration

1. **API Setup**: Configure your EventBookings API credentials in the settings page
2. **Event Display**: Customize which event details are displayed (descriptions, countdowns, maps, etc.)
3. **Environment**: Choose between development, staging, and production environments

## Features

### Core Functionality
- **Event Listing**: Display paginated event lists with filtering
- **Featured Events**: Highlight specific events in carousel format
- **Event Details**: Comprehensive event information pages
- **Ticket Booking**: Complete booking flow with form validation
- **Responsive Design**: Mobile-friendly event displays

### Admin Features
- **Settings Management**: Configure display options and API credentials
- **Event Synchronization**: Sync events from EventBookings service
- **Customization Options**: Control which event elements are displayed
- **Caching**: Built-in caching for improved performance

### Security
- **Nonce Verification**: All AJAX requests are nonce-protected
- **Data Sanitization**: Input data is properly sanitized
- **SQL Injection Prevention**: Prepared statements used throughout
- **Access Token Management**: Secure token refresh functionality

## System Requirements

- **WordPress**: 5.0 or higher
- **PHP**: 7.4 or higher
- **MySQL**: 5.6 or higher
- **Required Extensions**: cURL, JSON

## Database Tables

The plugin creates and manages several database tables:

- `wp_eb_plugin_users` - OAuth credentials storage
- `wp_events` - Event data cache
- `wp_eb_feature_events` - Featured events configuration
- `wp_customized_events` - Display settings per organization

## API Integration

The plugin integrates with EventBookings API endpoints:

- **Production**: `https://api-rto.eventbookings.com/v3`
- **Staging**: `https://api.doyour.events/v3`
- **Development**: `https://api.diywebsite.net.au/v2`

## Support

For technical support and documentation:

- **Developer Guide**: See `DEVELOPER_GUIDE.md` for technical implementation details
- **API Reference**: See `API_REFERENCE.md` for complete API documentation
- **User Manual**: See `USER_MANUAL.md` for end-user instructions
- **Components**: See `COMPONENTS.md` for frontend component documentation

## License

This plugin is licensed under the GPL v2 or later.

## Changelog

### Version 1.1
- Enhanced API error handling and token refresh
- Improved caching mechanism
- Added comprehensive logging
- Security improvements with nonce verification
- Better database schema management

### Version 1.0
- Initial release
- Basic event display functionality
- Admin settings interface
- Shortcode implementation