<?php
/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://siddiqur.com
 * @since      1.0.0
 *
 * @package    EU_Base_Price_Display
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * @since      1.0.0
 * @package    EU_Base_Price_Display
 * @author     Md Siddiqur Rahman <support@siddiqur.com>
 */
class EUBAPRDI_Loader {

	/**
	 * The admin-specific functionality of the plugin.
	 *
	 * @since 1.0.0
	 * @var EUBAPRDI_Admin|null $admin The admin instance.
     */
    private ?EUBAPRDI_Admin $admin = null;

	/**
	 * The public-facing functionality of the plugin.
	 *
	 * @since 1.0.0
	 * @var EUBAPRDI_Frontend|null $frontend The frontend instance.
     */
    private ?EUBAPRDI_Frontend $frontend = null;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		$this->eubaprdi_load_dependencies();
	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - EUBAPRDI_Admin. Defines all hooks for the admin area.
	 * - EUBAPRDI_Frontend. Defines all hooks for the public side.
	 *
	 * @since 1.0.0
	 * @access private
	 * @return void
	 * @throws Exception If required files cannot be loaded.
	 */
	private function eubaprdi_load_dependencies(): void {
		/**
		 * The class responsible for orchestrating the admin-specific functionality.
		 */
		$admin_file = EUBAPRDI_PLUGIN_DIR . 'includes/class-eubaprdi-admin.php';
		if ( ! file_exists( $admin_file ) ) {
			throw new Exception( 'Required admin class file not found: ' . esc_html( $admin_file ) );
		}
		require_once $admin_file;

		/**
		 * The class responsible for orchestrating the public-facing functionality.
		 */
		$frontend_file = EUBAPRDI_PLUGIN_DIR . 'includes/class-eubaprdi-frontend.php';
		if ( ! file_exists( $frontend_file ) ) {
			throw new Exception( 'Required frontend class file not found: ' . esc_html( $frontend_file ) );
		}
		require_once $frontend_file;
	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since 1.0.0
	 * @return void
	 * @throws Exception If there's an error initializing the plugin.
	 */
	public function eubaprdi_run(): void {
		try {
			if ( is_admin() ) {
				if ( ! class_exists( 'EUBAPRDI_Admin' ) ) {
					throw new Exception( 'EUBAPRDI_Admin class not found' );
				}
				$this->admin = new EUBAPRDI_Admin( EUBAPRDI_PLUGIN_NAME, EUBAPRDI_VERSION );
				$this->admin->eubaprdi_init_hooks();
			} else {
				if ( ! class_exists( 'EUBAPRDI_Frontend' ) ) {
					throw new Exception( 'EUBAPRDI_Frontend class not found' );
				}
				$this->frontend = new EUBAPRDI_Frontend( EUBAPRDI_PLUGIN_NAME, EUBAPRDI_VERSION );
				$this->frontend->eubaprdi_init_hooks();
			}
		} catch ( Exception $e ) {
			// Error is rethrown to be handled by the main plugin file
			// No debug logging in production
			throw $e;
		}
	}
}
