/**
 * SVG Icon Components for Flexbox Justify Content Values
 * These icons visually represent how items are distributed in a flex container
 */

export const DirectionRowIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g clipPath="url(#clip0_6429_1682)">
            <path d="M18 16L3 16" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M16 6L18 8L16 10" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M16 18L18 16L16 14" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M18 8L3 8" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M21 3L21 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        </g>
        <defs>
            <clipPath id="clip0_6429_1682">
                <rect width="24" height="24" fill="white" />
            </clipPath>
        </defs>
    </svg>
);
export const DirectionColumnIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g clipPath="url(#clip0_6429_1699)">
            <path d="M8 18L8 3" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M18 16L16 18L14 16" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M6 16L8 18L10 16" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M16 18L16 3" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M21 21L3 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        </g>
        <defs>
            <clipPath id="clip0_6429_1699">
                <rect width="24" height="24" fill="white" transform="translate(24) rotate(90)" />
            </clipPath>
        </defs>
    </svg>

);
export const DirectionRowReverseIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M6 8L21 8" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <path d="M8 18L6 16L8 14" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <path d="M8 6L6 8L8 10" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <path d="M6 16L21 16" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <path d="M3 21L3 3" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
    </svg>
);
export const DirectionColumnReverseIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M16 6L16 21" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <path d="M6 8L8 6L10 8" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <path d="M18 8L16 6L14 8" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <path d="M8 6L8 21" stroke="#5C626D" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <path d="M3 3H21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
    </svg>
);

export const JustifyFlexStartIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g clipPath="url(#clip0_6429_1741)">
            <path d="M3 3L3 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <rect x="6" y="6" width="4" height="12" rx="0.2" fill="#5C626D" />
            <rect x="12" y="6" width="4" height="12" rx="0.2" fill="#5C626D" />
        </g>
        <defs>
            <clipPath id="clip0_6429_1741">
                <rect width="24" height="24" fill="white" />
            </clipPath>
        </defs>
    </svg>
);
export const JustifyCenterIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g clipPath="url(#clip0_6429_1767)">
            <path d="M21 3L21 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M3 3L3 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <rect x="7.5" y="6" width="4" height="12" rx="0.2" fill="#5C626D" />
            <rect x="12.5" y="6" width="4" height="12" rx="0.2" fill="#5C626D" />
        </g>
        <defs>
            <clipPath id="clip0_6429_1767">
                <rect width="24" height="24" fill="white" />
            </clipPath>
        </defs>
    </svg>
);
export const JustifyFlexEndIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g clipPath="url(#clip0_6429_1756)">
            <path d="M21 3L21 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <rect x="8" y="6" width="4" height="12" rx="0.2" fill="#5C626D" />
            <rect x="14" y="6" width="4" height="12" rx="0.2" fill="#5C626D" />
        </g>
        <defs>
            <clipPath id="clip0_6429_1756">
                <rect width="24" height="24" fill="white" />
            </clipPath>
        </defs>
    </svg>

);
export const JustifySpaceBetweenIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g clipPath="url(#clip0_6429_1761)">
            <path d="M21 3L21 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M3 3L3 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <rect x="5" y="6" width="4" height="12" rx="0.2" fill="#5C626D" />
            <rect x="15" y="6" width="4" height="12" rx="0.2" fill="#5C626D" />
        </g>
        <defs>
            <clipPath id="clip0_6429_1761">
                <rect width="24" height="24" fill="white" />
            </clipPath>
        </defs>
    </svg>
);
export const JustifySpaceAroundIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g clipPath="url(#clip0_6429_1773)">
            <path d="M20.5 3L20.5 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M3 3L3 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <rect x="6.5" y="6" width="4" height="12" rx="0.2" fill="#5C626D" />
            <rect x="13.5" y="6" width="4" height="12" rx="0.2" fill="#5C626D" />
        </g>
        <defs>
            <clipPath id="clip0_6429_1773">
                <rect width="24" height="24" fill="white" />
            </clipPath>
        </defs>
    </svg>
);
export const JustifySpaceEvenlyIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g clipPath="url(#clip0_6429_1773)">
            <path d="M20.5 3L20.5 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M3 3L3 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <rect x="6.5" y="6" width="4" height="12" rx="0.2" fill="#5C626D" />
            <rect x="13.5" y="6" width="4" height="12" rx="0.2" fill="#5C626D" />
        </g>
        <defs>
            <clipPath id="clip0_6429_1773">
                <rect width="24" height="24" fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export const AlignFlexStartIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M21 3L3 3" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <rect x="18" y="6" width="4" height="12" rx="0.2" transform="rotate(90 18 6)" fill="#5C626D" />
        <rect x="18" y="12" width="4" height="12" rx="0.2" transform="rotate(90 18 12)" fill="#5C626D" />
    </svg>
);
export const AlignCenterIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M21 3L3 3" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <path d="M21 21L3 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <rect x="18" y="7" width="4" height="12" rx="0.2" transform="rotate(90 18 7)" fill="#5C626D" />
        <rect x="18" y="13" width="4" height="12" rx="0.2" transform="rotate(90 18 13)" fill="#5C626D" />
    </svg>
);
export const AlignFlexEndIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M3 21L21 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
        <rect x="6" y="18" width="4" height="12" rx="0.2" transform="rotate(-90 6 18)" fill="#5C626D" />
        <rect x="6" y="12" width="4" height="12" rx="0.2" transform="rotate(-90 6 12)" fill="#5C626D" />
    </svg>
);
export const AlignStretchIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g clipPath="url(#clip0_6429_1802)">
            <path d="M3 21L21 21" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <path d="M3 3L21 3" stroke="#B2B7C0" strokeWidth="1.2" strokeLinecap="round" strokeLinejoin="round" />
            <rect x="6" y="18" width="5" height="12" rx="0.2" transform="rotate(-90 6 18)" fill="#5C626D" />
            <rect x="6" y="11" width="5" height="12" rx="0.2" transform="rotate(-90 6 11)" fill="#5C626D" />
        </g>
        <defs>
            <clipPath id="clip0_6429_1802">
                <rect width="24" height="24" fill="white" />
            </clipPath>
        </defs>
    </svg>
);
export const WrapIcon = () => (
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" className="eb-flex-wrap-icon" xmlns="http://www.w3.org/2000/svg">
        <g clipPath="url(#clip0_6429_1818)">
            <path d="M21.5996 15.7998C21.5996 16.2416 21.2416 16.5996 20.7998 16.5996H12.4473L13.4238 17.5762C13.6581 17.8105 13.6581 18.1895 13.4238 18.4238C13.1895 18.6581 12.8105 18.6581 12.5762 18.4238L10.5762 16.4238C10.3419 16.1895 10.3419 15.8105 10.5762 15.5762L12.5762 13.5762C12.8105 13.3419 13.1895 13.3419 13.4238 13.5762C13.6581 13.8105 13.6581 14.1895 13.4238 14.4238L12.4473 15.4004H20.4004V6.59961H6C5.66863 6.59961 5.40039 6.33137 5.40039 6C5.40039 5.66863 5.66863 5.40039 6 5.40039H20.7998C21.2416 5.40039 21.5996 5.75837 21.5996 6.2002V15.7998Z" clipRule="evenodd" />
            <path d="M3.59961 21C3.59961 21.3314 3.33137 21.5996 3 21.5996C2.66863 21.5996 2.40039 21.3314 2.40039 21L2.40039 3C2.40039 2.66863 2.66863 2.40039 3 2.40039C3.33137 2.40039 3.59961 2.66863 3.59961 3L3.59961 21Z" clipRule="evenodd" />
        </g>
        <defs>
            <clipPath id="clip0_6429_1818">
                <rect width="24" height="24" fill="white" />
            </clipPath>
        </defs>
    </svg>
);
export const NoWrapIcon = () => (
    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" className="eb-flex-wrap-icon" xmlns="http://www.w3.org/2000/svg">
        <path d="M16.1758 7.17574C16.4101 6.94142 16.7891 6.94142 17.0234 7.17574L19.0234 9.17574C19.136 9.28826 19.1992 9.44043 19.1992 9.59956C19.1992 9.75869 19.136 9.91087 19.0234 10.0234L17.0234 12.0234C16.7891 12.2577 16.4101 12.2577 16.1758 12.0234C15.9415 11.7891 15.9415 11.4101 16.1758 11.1757L17.1523 10.1992H3.59961C3.26824 10.1992 3 9.93093 3 9.59956C3 9.26819 3.26824 8.99995 3.59961 8.99995H17.1523L16.1758 8.02339C15.9415 7.78908 15.9415 7.41005 16.1758 7.17574Z" />
        <path d="M0 18.5996V0.599609C1.44847e-08 0.268239 0.268239 4.25181e-07 0.599609 0C0.93098 1.44847e-08 1.19922 0.268239 1.19922 0.599609V18.5996C1.19922 18.931 0.93098 19.1992 0.599609 19.1992C0.268239 19.1992 -3.10838e-10 18.931 0 18.5996Z" clipRule="evenodd" />
    </svg>
);
