<?php
defined('ABSPATH') || exit;
?>

<div class="eaw-wishlist-container">
    <?php if (empty($wishlist) || !is_array($wishlist)) : ?>
        <div class="eaw-wishlist-empty">
            <p><?php esc_html_e('Your wishlist is empty.', 'essential-addons-for-woocommerce'); ?></p>
            <a href="<?php echo esc_url(get_permalink(wc_get_page_id('shop'))); ?>" class="eaw-button button">
                <?php esc_html_e('Return to shop', 'essential-addons-for-woocommerce'); ?>
            </a>
        </div>
    <?php else : ?>
        <div class="eaw-wishlist-wrapper">
            <div class="eaw-wishlist-header">
                <h2><?php esc_html_e('Wishlist', 'essential-addons-for-woocommerce'); ?></h2>
            </div>

            <div class="eaw-wishlist-items">
                <!-- Header Row -->
                <div class="eaw-wishlist-item eaw-wishlist-item-header">
                    <div class="eaw-wishlist-column eaw-wishlist-image"><?php esc_html_e('Image', 'essential-addons-for-woocommerce'); ?></div>
                    <div class="eaw-wishlist-column eaw-wishlist-product"><?php esc_html_e('Product', 'essential-addons-for-woocommerce'); ?></div>
                    <div class="eaw-wishlist-column eaw-wishlist-quantity"><?php esc_html_e('Quantity', 'essential-addons-for-woocommerce'); ?></div>
                    <div class="eaw-wishlist-column eaw-wishlist-price"><?php esc_html_e('Price', 'essential-addons-for-woocommerce'); ?></div>
                    <div class="eaw-wishlist-column eaw-wishlist-actions"><?php esc_html_e('Actions', 'essential-addons-for-woocommerce'); ?></div>
                </div>

                <!-- Wishlist Items -->
                <?php foreach ($wishlist as $item) :
                    $product = wc_get_product($item);
                    if (!$product || !($product instanceof WC_Product)) {
                        continue;
                    } // Skip invalid products
                    $product_id = $product->get_id();
                    ?>
                    <div class="eaw-wishlist-item" data-productid="<?php echo esc_attr($product_id); ?>">
                        <div class="eaw-wishlist-column eaw-wishlist-image">
                            <?php
                                echo $product->get_image_id()
                                    ? wp_kses_post($product->get_image('woocommerce_thumbnail'))
                                    : sprintf(
                                        '<img src="%s" alt="%s" width="100" height="100">',
                                        esc_url(wc_placeholder_img_src('woocommerce_thumbnail')),
                                        esc_attr__('Placeholder', 'essential-addons-for-woocommerce')
                                    );
                    ?>
                        </div>

                        <div class="eaw-wishlist-column eaw-wishlist-product">
                            <a href="<?php echo esc_url($product->get_permalink()); ?>">
                                <?php echo esc_html($product->get_title()); ?>
                            </a>
                        </div>

                    <div class="eaw-wishlist-column eaw-wishlist-quantity">
                        <?php
                        if (! function_exists('woocommerce_quantity_input')) {
                            include_once WC()->plugin_path() . '/includes/wc-template-functions.php';
                        }
                    woocommerce_quantity_input([
                        'input_name'  => 'eaw_wishlist_qty_' . $product_id,
                        'min_value'   => apply_filters('woocommerce_quantity_input_min', 1, $product),
                        'max_value'   => apply_filters('woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product),
                        'input_value' => 1,
                        'classes'     => ['input-text', 'qty', 'text', 'eaw-wishlist-quantity-input', 'eaw-custom-quantity-input'],
                        'inputmode'   => 'numeric',
                    ], $product, true);
                    ?>
                    </div>

                    <div class="eaw-wishlist-column eaw-wishlist-price">
                        <?php
                    $price_html = $product->get_price_html();
                    echo $price_html ? wp_kses_post($price_html) : esc_html__('Price not available', 'essential-addons-for-woocommerce');
                    ?>
                    </div>

                    <div class="eaw-wishlist-column eaw-wishlist-actions">
                        <div class="eaw-buttons-actions-wrapper">
                            <div class="eaw-buttons-actions eaw-wishlist-add-to-cart">
                                <?php if ($product->get_type() === 'variable') : ?>
                                    <a data-producttype="<?php echo esc_attr($product->get_type()); ?>"
                                        href="<?php echo esc_url($product->get_permalink()); ?>"
                                        class="eaw-action-button"
                                        title="<?php esc_attr_e('Add to cart', 'essential-addons-for-woocommerce'); ?>"
                                        data-productid="<?php echo esc_attr($product_id); ?>">
                                        <span class="eaw-icon-cart"></span>
                                    </a>
                                <?php else : ?>
                                    <?php $disabled = esc_html($product->is_in_stock()) && esc_html($product->is_purchasable()) ? '' : esc_html('disabled'); ?>
                                    <button <?php echo esc_html(disabled); ?>
                                        class="eaw-action-button eaw-add-to-cart-button"
                                        title="<?php esc_attr_e('Add to cart', 'essential-addons-for-woocommerce'); ?>"
                                        data-productid="<?php echo esc_attr($product_id); ?>">
                                        <span class="eaw-icon-cart"></span>
                                    </button>
                                <?php endif; ?>
                            </div>

                            <div class="eaw-buttons-actions">
                                <button class="eaw-action-button eaw-delete-button"
                                    title="<?php esc_attr_e('Delete', 'essential-addons-for-woocommerce'); ?>"
                                    data-productid="<?php echo esc_attr($product_id); ?>">
                                    <span class="eaw-icon-delete"></span>
                                </button>
                            </div>
                        </div>
                    </div>
            </div>
        <?php endforeach; ?>
        </div>
</div>
<?php endif; ?>
</div>