<?php defined('ABSPATH') || exit; ?>

<?php
global $post, $product;

// Extract product data
$productData              = $args['productData'];
$DisplayQuickViewSettings = $args['DisplayQuickViewSettings'];

$productId = $productData['id'];

if (!$productId) {
    return;
}

$post = get_post($productId);
setup_postdata($post);
$product = wc_get_product($productId);

// Extract settings dynamically
foreach ($DisplayQuickViewSettings as $key => $value) {
    ${$key} = $value;
}

// Ensure necessary settings exist
$showElementOnQuickView = $DisplayQuickViewSettings['showElementOnQuickView'] ?? [];

// Get product details
$featuredImage = esc_url($productData['featuredImage']);
$galleryImages = $productData['galleryImages'];
$productType   = $productData['productType'] ?? 'simple';
?>

<div class="eaw-product-quick-view-popup-content-wrapper eaw-product-type-<?php echo esc_attr($productType); ?>" data-id="<?php echo esc_attr($productId); ?>">
    <div class="eaw-product-popup">
        <div class="eaw-product-popup-content-wrapper">
            <div class="eaw-product-popup-content">

                <!-- Product Images & Gallery -->
                <!-- <?php if (in_array('showProductImage', $showElementOnQuickView, true)) : ?> -->
                <div class="eaw-product-gallery">
                    <?php if (!empty($galleryImages) && count($galleryImages) > 1) : ?>
                        <div class="eaw-product-gallery-images">
                            <?php foreach ($galleryImages as $galleryImage) : ?>
                                <?php
                                    $image_id = attachment_url_to_postid($galleryImage);
                                ?>
                                <div class="eaw-product-gallery-image" data-image-id="<?php echo esc_attr($image_id); ?>">
                                    <img src="<?php echo esc_url($galleryImage); ?>" alt="<?php echo esc_attr(get_the_title($productId)); ?>">
                                </div>
                            <?php endforeach; ?>
                        </div>

                        <div class="eaw-product-gallery-thumbs">
                            <?php foreach ($galleryImages as $galleryImage) : ?>
                                <div class="eaw-product-gallery-thumb">
                                    <img src="<?php echo esc_url($galleryImage); ?>" alt="<?php echo esc_attr(get_the_title($productId)); ?>">
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else : ?>
                        <div class="eaw-product-featured-image">
                            <img src="<?php echo esc_url($featuredImage); ?>" alt="<?php echo esc_attr(get_the_title($productId)); ?>">
                        </div>
                    <?php endif; ?>
                </div>
                <!-- <?php endif; ?> -->

                <!-- Product Content -->
                <div class="eaw-product-content">
                    <?php do_action('ccpeaw_product_content', $productId); ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php wp_reset_postdata(); // Reset post data to avoid conflicts
?>