<?php

use CodeConfig\EAW\AppSettings;

defined('ABSPATH') || exit('No direct script access allowed');

$settings = AppSettings::getInstance();

$selectCustomQuantityItem = $settings->getParams('cqItem');
$enableInlineQuantity     = $settings->getParams('enableInlineQuantity');
$checkCustomQuantity      = $settings->getParams('checkCustomQuantity');

$checkQuantityText = $settings->getParams('showQuantityText');
$quantityText      = $settings->getParams('quantityText') ? $settings->getParams('quantityText') : esc_html__('Quantity', 'essential-addons-for-woocommerce');

global $product; // Get the current product object
$is_variable_product = $product && $product->is_type('variable');

do_action('ccpeaw_before_eaw_custom_quantity');

?>

<div id="eaw-custom-quantity" class="<?php echo $is_variable_product ? 'eaw-disabled' : ''; ?>">
    <?php if ($checkQuantityText) : ?>
        <div class="eaw-quantity-text">
            <span class="eaw-quantity-text-label"><?php echo esc_html($quantityText); ?></span>
        </div>
    <?php endif; ?>
    <div class="eaw-custom-quantity eaw-quantity-<?php echo esc_attr($selectCustomQuantityItem); ?>">
        <?php do_action('ccpeaw_before_quantity_input_field'); ?>

        <div class="quantity-trigger eaw-minus">
        </div>

        <div class="eaw-quantity-input">
            <input
                type="<?php echo esc_attr($type); ?>"
                id="<?php echo esc_attr($input_id); ?>"
                class="<?php echo esc_attr(join(' ', (array) $classes)); ?> eaw-custom-quantity-input"
                name="<?php echo esc_attr($input_name); ?>"
                value="<?php echo esc_attr($input_value ?? 0); ?>"
                aria-label="<?php esc_attr_e('Product quantity', "essential-addons-for-woocommerce"); ?>"
                <?php if (in_array($type, ['text', 'search', 'tel', 'url', 'email', 'password'], true)) : ?>
                size="4"
                <?php endif; ?>
                min="<?php echo esc_attr($min_value); ?>"
                max="<?php echo esc_attr(0 < $max_value ? $max_value : ''); ?>"
                step="<?php echo esc_attr($step); ?>"
                placeholder="<?php echo esc_attr($placeholder); ?>"
                inputmode="<?php echo esc_attr($inputmode); ?>"
                autocomplete="<?php echo esc_attr(isset($autocomplete) ? $autocomplete : 'on'); ?>" />
        </div>

        <div class="quantity-trigger eaw-plus ">
        </div>
        <?php
        do_action('ccpeaw_after_quantity_input_field');
?>
    </div>
</div>
<?php
