<?php

/**
 * Template for rendering the single product gallery slider
 *
 * @package CodeConfig\EAW
 * @var array $sliderSettings Slider settings
 * @var WC_Product $product WooCommerce product object
 * @var array $images Processed images (featured, gallery, variation)
 */

defined('ABSPATH') || exit('No direct script access allowed');

// Build gallery classes
$galleryClass = '';
if (!empty($sliderSettings['galleryNavPosition'])) {
    $galleryClass .= ' eaw-nav-' . esc_attr($sliderSettings['galleryNavPosition']);
}
if (!empty($sliderSettings['selectPaginationType'])) {
    $galleryClass .= ' eaw-pagination-' . esc_attr($sliderSettings['selectPaginationType']);
}
$elementorClass = apply_filters('eaw_gallery_slider_elementor_class', '');
?>

<style type="text/css">
    :root {
        --eaw-sliderNavBorderRadius:
            <?php echo esc_attr($sliderSettings['sliderNavBorderRadius'] . 'px'); ?>
        ;
        --eaw-arrowBgColor:
            <?php echo esc_attr($sliderSettings['arrowColors']['background']); ?>
        ;
        --eaw-arrowActiveBgColor:
            <?php echo esc_attr($sliderSettings['arrowColors']['backgroundHover']); ?>
        ;
        --eaw-arrowIconColor:
            <?php echo esc_attr($sliderSettings['arrowColors']['arrowIconColor']); ?>
        ;
        --eaw-arrowIconColorHover:
            <?php echo esc_attr($sliderSettings['arrowColors']['arrowIconColorHover']); ?>
        ;
    }
</style>

<div class="eaw-single-product-gallery-wrapper woocommerce-product-gallery images <?php echo 'eaw-gallery-' . esc_attr($sliderSettings['galleryLayout']);
echo $sliderSettings['vertical'] == '1' ? "eaw-gallery-vertical" : '';
echo esc_attr($elementorClass); ?>">
    <div class="eaw-single-product-gallery">
        <?php if (!empty($images) && count($images) > 1): ?>
            <div class="eaw-single-product-gallery-images-wrapper">
                <div class="eaw-single-product-gallery-images <?php echo esc_attr($galleryClass); ?>">
                    <?php foreach ($images as $image): ?>
                        <div class="eaw-single-product-gallery-image" data-attachmentid="<?php echo esc_attr($image['id']); ?>">
                            <img src="<?php echo esc_url($image['src']); ?>" alt="<?php echo esc_attr($image['alt']); ?>"
                                loading="lazy" class="wp-post-image" data-id="<?php echo esc_attr($image['id']); ?>"
                                data-large="<?php echo esc_url($image['src']); ?>">
                        </div>
                    <?php endforeach; ?>
                </div>

                <?php if (($sliderSettings['selectPaginationType'] == 'progress') && count($images) > 1): ?>
                    <div class="eaw-slider__progress-container">
                        <div class="eaw-slider__progress-bar" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                <?php endif; ?>
                
                <?php if (is_shop()) : ?>
                    <button class="eaw-slider-arrow prev"></button>
                    <button class="eaw-slider-arrow next"></button>
                    <div class="eaw-slider-dots"></div>
                <?php endif; ?>
            </div>

        <?php elseif (!empty($images) && count($images) == 1): ?>
            <div class="eaw-single-product-gallery-images-wrapper">
                <div class="eaw-single-product-gallery-image">
                    <img src="<?php echo esc_url($images[0]['src']); ?>" alt="<?php echo esc_attr($images[0]['alt']); ?>"
                        loading="lazy" class="wp-post-image" data-id="<?php echo esc_attr($images[0]['id']); ?>">
                </div>
            </div>


        <?php else: ?>
            <div class="eaw-single-product-gallery-placeholder">
                <?php esc_html_e('No images available for this product.', 'essential-addons-for-woocommerce'); ?>
            </div>
        <?php endif; ?>

        <?php


       if (($sliderSettings['enable_thumbnail'] && count($images) > 1) && is_product()): ?>
            <div class="eaw-single-product-gallery-thumbnails">
                <?php foreach ($images as $image): ?>
                    <div class="eaw-single-product-gallery-thumbnail">
                        <img src="<?php echo esc_url($image['src']); ?>" alt="<?php echo esc_attr($image['alt']); ?>"
                            loading="lazy" class="wp-post-image" data-id="<?php echo esc_attr($image['id']); ?>">
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

    </div>

    <?php do_action('eaw_after_single_product_slider'); ?>
</div>