<?php if (! defined('ABSPATH')) {
    exit;
} ?>
<div class="eaw-recently-viewed-product" data-product-id="<?php echo esc_attr($product_id); ?>">
    <div class="eaw-product-image">
        <?php woocommerce_template_loop_product_thumbnail(); ?>

        <?php if ($settings['delete'] == '1') : ?>
            <div class="eaw-remove-product" data-product-id="<?php echo esc_attr($product_id); ?>"><i class="dashicons dashicons-no-alt"></i></div>
        <?php endif; ?>

    </div>

    <div class="eaw-product-info">
        <a class="eaw-product-title" href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html(get_the_title()); ?></a>
    </div>

    <div class="eaw-product-price">
        <?php echo esc_html(wc_price($product->get_price())); ?>
    </div>

    <!-- add to cart -->
    <div class="eaw-product-add-to-cart">
        <?php if ($product->is_purchasable()) : ?>
            <?php $product_name = $product->get_name(); ?>
            <a href="<?php echo esc_url($product->add_to_cart_url()); ?>"
                aria-describedby="woocommerce_loop_add_to_cart_link_describedby_<?php echo esc_attr($product_id); ?>"
                data-quantity="1"
                class="button product_type_simple add_to_cart_button ajax_add_to_cart"
                data-product_id="<?php echo esc_attr($product_id); ?>"
                aria-label="Add to cart: &ldquo;<?php echo esc_attr($product_name); ?>&rdquo;"
                rel="nofollow"
                data-success_message="&ldquo;<?php echo esc_html($product_name); ?>&rdquo; has been added to your cart">
                <?php esc_html_e('Add To Cart', 'essential-addons-for-woocommerce'); ?>
            </a>
        <?php endif; ?>
    </div>
</div>