<?php defined(constant_name: 'ABSPATH') || exit('No direct script access allowed');

// Extract product data
$productData             = $args['productData'];
$productId               = $productData['id'];
$productTitle            = $productData['title'];
$productShortDescription = $productData['shortDescription'];
// price with currency from product id
$currency     = get_woocommerce_currency_symbol();
$price        = $productData['price'];
$regularPrice = $productData['regularPrice'] ?? null;
$salePrice    = $productData['salePrice']    ?? null;

// Get product images
$featuredImage    = wp_get_attachment_url(get_post_thumbnail_id($productId));
$placeholderImage = wc_placeholder_img_src();
$image            = $featuredImage ?: $placeholderImage;

// Quantity inputs
$quantityInputMin = get_post_meta($productId, '_min_quantity', true);
$quantityInputMax = get_post_meta($productId, '_max_quantity', true);

// Get product attributes and type-specific data
$product    = wc_get_product($productId);
$attributes = $product->get_attributes();

// Get product type from product id
$productType = $product->get_type();

$groupedProducts = [];
if ($product->is_type('grouped')) {
    $groupedProducts = $product->get_children();
}

// Device classes
$deviceClasses = '';
if (!empty($DisplayQuickViewSettings['quickViewDisplayDevices'])) {
    $deviceClasses = implode(' ', array_map(function ($deviceType) {
        return 'eaw-display-' . strtolower($deviceType);
    }, $DisplayQuickViewSettings['quickViewDisplayDevices']));
}

// Extract display settings dynamically
$settingsKeys = [
    'showProductImage',
    'quickShowProductName',
    'quickShowProductRating',
    'quickShowProductPrice',
    'quickShowProductShortDescription',
    'quickShowAddToCart',
    'quickShowWishlist',
    'quickShowProductMeta',
    'quickShowProductTags',
    'quickShowProductCategories',
    'quickViewLightBox',
    'quickViewGallery',
    'quickViewModalHeight',
    'quickViewModalWidth',
    'quickViewFontSize',
    'quickViewBtnRadius',
    'quickViewBackgroundColor',
    'enableViewDetailsBtn',
    'viewDetailsBtnTxt',
    'viewDetailsBackgroundColor',
    'viewDetailsTextColor',
    'viewDetailsBorderColor',
    'viewDetailsBackgroundColorHover',
    'viewDetailsTextColorHover',
    'viewDetailsBorderColorHover',
    'enableAjaxAddToCartOnQuickView',
];

foreach ($settingsKeys as $key) {
    ${$key} = $DisplayQuickViewSettings[$key] ?? null;
}

?>

<div class="eaw-product-popup-wrapper <?php echo esc_attr($deviceClasses); ?>">
    <div class="eaw-product-popup">
        <div class="eaw-product-popup-content">
            <?php if ($quickViewGallery) :
                $galleryImages = $product->get_gallery_image_ids();
                if ($galleryImages) :
                    ?>
                    <div class="eaw-product-gallery">
                        <div class="eaw-product-gallery-images">
                            <?php
                                    foreach ($galleryImages as $galleryImageId) {
                                        $galleryImage = wp_get_attachment_url($galleryImageId);
                                        echo '<div class="eaw-product-gallery-image"><img src="' . esc_url($galleryImage) . '" alt="' . esc_attr($productTitle) . '"></div>';
                                    }
                    ?>
                        </div>
                    </div>
                <?php else : ?>
                    <div class="eaw-product-featured-image eaw-zoomable-image-container">
                        <img src="<?php echo esc_url($image); ?>" class="eaw-zoomable-image" alt="<?php echo esc_attr($productTitle); ?>">
                    </div>
            <?php endif;
endif; ?>

            <div class="eaw-product-content">
                <?php if ($quickShowProductName) : ?>
                    <div class="eaw-product-title">
                        <h2>
                            <a href="<?php echo esc_url(get_permalink($productId)); ?>"><?php echo esc_html($productTitle); ?></a>
                        </h2>

                    </div>
                <?php endif; ?>

                <?php if ($quickShowProductRating && $product->get_average_rating()) : ?>
                    <?php echo esc_html(wc_get_rating_html($product->get_average_rating())); ?>
                <?php endif; ?>

                <?php if (!empty($productShortDescription)) : ?>
                    <div class="eaw-product-short-description">
                        <?php echo wp_kses_post($productShortDescription); ?>
                    </div>
                <?php endif; ?>

                <?php if (!empty($productCategories) && wc_get_product_category_list($productId, ', ')) : ?>
                    <div class="eaw-product-categories">
                        <p><strong><?php echo esc_html__('Categories', "essential-addons-for-woocommerce"); ?>: </strong> <?php echo esc_html(wc_get_product_category_list($productId, ', ')); ?></p>
                    </div>
                <?php endif; ?>

                <?php if (!empty($quickShowProductMeta) && !empty($product->get_sku())) : ?>
                    <div class="eaw-product-meta">
                        <div class="eaw-product-sku">
                            <p> <strong><?php echo esc_html__('SKU', "essential-addons-for-woocommerce"); ?>: </strong> <?php echo esc_html($product->get_sku()); ?></p>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (!empty($quickShowProductPrice) && !empty($price)) : ?>
                    <div class="eaw-product-price">
                        <?php printf('<strong>%s: </strong>%s%s', esc_html__('Price', "essential-addons-for-woocommerce"), esc_html($currency), esc_html($price)); ?>
                    </div>
                <?php endif; ?>

                <?php if ($quickShowWishlist) : ?>
                    <div class="eaw-product-wishlist">
                        <div class="eaw-product-wishlist-button">
                            <span class="eaw-icon eaw-icon-heart"></span>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if (!empty($attributes)) : ?>
                    <div class="eaw-product-attributes">
                        <?php

            foreach ($attributes as $attribute) {
                if ($attribute->is_taxonomy()) {
                    $taxonomy = $attribute->get_name();
                    $terms    = wc_get_product_terms($productId, $taxonomy, ['fields' => 'names']);

                    $getTerm = implode(', ', $terms);

                    echo '<div class="eaw-product-attribute">';
                    echo '<div class="eaw-product-attribute-label">' . esc_html($attribute->get_name()) . '</div>';
                    echo '<div class="eaw-product-attribute-value">' . esc_html($getTerm) . '</div>';
                    echo '</div>';
                } else {

                    echo '<div class="eaw-product-attribute">';
                    echo '<div class="eaw-product-attribute-label">' . esc_html($attribute->get_name()) . '</div>';
                    echo '<div class="eaw-product-attribute-value">' . esc_html($attribute->get_options()[0]) . '</div>';
                    echo '</div>';
                }
            }
?>
                    </div>
                <?php endif; ?>

                <?php if (!empty($groupedProducts) && $product->is_type('grouped')) : ?>
                    <div class="eaw-product-grouped-products">
                        <!-- Loop through grouped products with quantity field -->
                        <?php foreach ($groupedProducts as $groupedProductId) : ?>
                            <?php
    $groupedProduct                                 = wc_get_product($groupedProductId);
                            $productId              = $groupedProduct->get_id();
                            $groupedProductName     = $groupedProduct->get_title();
                            $groupedProductQuantity = get_post_meta($groupedProductId, '_qty', true);
                            ?>
                            <div class="eaw-product-grouped-product">
                                <div class="eaw-product-grouped-product-name">
                                    <?php echo esc_html($groupedProductName); ?>
                                </div>
                                <div class="eaw-product-grouped-product-quantity">
                                    <div class="eaw-product-add-to-cart">
                                        <div class="eaw-cart-quantity">
                                            <?php
                                            do_action('woocommerce_before_add_to_cart_quantity');
                            woocommerce_quantity_input([
                                'input_name'   => 'quantity',
                                'input_value'  => 1,
                                'min_value'    => $quantityInputMin,
                                'max_value'    => $quantityInputMax,
                                'product_name' => $productTitle,
                            ]);
                            do_action('woocommerce_after_add_to_cart_quantity');
                            ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="eaw-product-add-to-cart-button">
                                    <button data-ccpeaw_product_id="<?php echo esc_attr($productId); ?>" class="eaw-group-add-to-cart-product button">
                                        <?php echo esc_html($product->single_add_to_cart_text()); ?>
                                    </button>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <?php
                if ($quickShowAddToCart && $product->is_purchasable() && $product->is_in_stock() && !$groupedProducts) : ?>
                    <div class="eaw-product-add-to-cart">
                        <div class="eaw-cart-quantity">
                            <?php
                            woocommerce_quantity_input([
                                'input_name'   => 'quantity',
                                'input_value'  => 1,
                                'min_value'    => apply_filters('woocommerce_quantity_input_min', 1, $product),
                                'max_value'    => apply_filters('woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product),
                                'product_name' => $productTitle,
                            ]);
                    ?>
                        </div>

                        <div class="eaw-product-add-to-cart-button">
                            <button data-ccpeaw-product-id="<?php echo esc_attr($productId); ?>" data-isenable-ajax="<?php echo esc_attr($enableAjaxAddToCartOnQuickView); ?>" data-ccpeaw-product-type="<?php echo esc_attr($productType); ?>" class="eaw-add-to-cart-product button">
                                <?php echo esc_html($product->single_add_to_cart_text()); ?>
                            </button>

                            <?php
                    if (!empty($enableViewDetailsBtn) && $viewDetailsBtnTxt) {
                        printf('<a href="%s" class="eaw-view-details-product button">%s</a>', esc_url($product->get_permalink()), esc_html($viewDetailsBtnTxt));
                    }
                    ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>