<?php if (! defined('ABSPATH')) {
    exit;
} ?>
<?php
$attribute       = $data['attribute'];
$type            = $data['type'];
$attribute_name  = sanitize_title($attribute->get_name());
$display_status  = $type == 'label' ? 'display: table' : 'display: none';
$controller      = $data['controller'];
$post_id         = $data['post_id'];
?>

<table class="ccpeaw-custom-table ccpeaw-custom-table-label" style="<?php echo esc_attr($display_status); ?>">
    <?php
    $i = 0;
foreach ($attribute->get_options() as $term) {
    $css  = $i == 0 ? 'display:table-row-group' : '';
    $open = $i == 0 ? 'open' : '';
    ?>
        <tr class="ccpeaw-term-name">
            <td colspan="2">
                <h3 class="ccpeaw-local-head <?php echo esc_attr($open); ?>" data-type="<?php echo esc_attr($type); ?>" data-term_name="<?php echo  esc_attr($term); ?>" onclick="ccpeaw_open_body(this,event)"><?php echo esc_html($term); ?></h3>
                <table class="ccpeaw-local-body-table">
                    <tbody class="ccpeaw-local-body ccpeaw-local-body-<?php echo esc_attr($term); ?>" style="<?php echo esc_attr($css); ?>">
                        <tr>
                            <td width="30%"><?php esc_html_e('Term Name', 'essential-addons-for-woocommerce') ?></td>
                            <td width="70%"><?php echo esc_html($term); ?></td>
                        </tr>
                        <tr class="form-field">
                            <td><?php esc_html_e('Label Text', 'essential-addons-for-woocommerce') ?></td>
                            <td>
                                <?php $term_field = $type == 'label' ? $controller->getCustomFieldsSettings($post_id, $attribute_name, $term, 'term_value') : '';
    $term_field                                   = ($term_field) ? $term_field : '';
    ?>
                                <input type="text" class="i_label" name="<?php echo esc_attr(sanitize_title('label_' . $attribute_name . '_term_' . $term)); ?>" style="width:275px;" value="<?php echo esc_attr($term_field); ?>">
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>

    <?php
        $i++;
}
?>
</table>