<?php if (! defined('ABSPATH')) {
    exit;
} ?>
<?php
$attribute       = $data['attribute'];
$type            = $data['type'];
$attribute_name  = sanitize_title($attribute->get_name());
$display_status  = $type == 'image' ? 'display: table' : 'display: none';
$controller      = $data['controller'];
$post_id         = $data['post_id'];
?>
<table class="ccpeaw-custom-table ccpeaw-custom-table-image" style="<?php echo esc_attr($display_status); ?>">
    <?php
    $i = 0;
foreach ($attribute->get_options() as $term) {
    $css  = $i == 0 ? 'display:table-row-group' : '';
    $open = $i == 0 ? 'open' : '';
    ?>
        <tr class="ccpeaw-term-name">
            <td colspan="2">
                <h3 class="ccpeaw-local-head <?php echo esc_attr($open); ?>" data-term_name="<?php echo esc_attr($term); ?>" onclick="ccpeaw_open_body(this,event)"><?php echo esc_html($term); ?></h3>
                <table class="ccpeaw-local-body-table">
                    <tbody class="ccpeaw-local-body ccpeaw-local-body-<?php echo esc_attr($term); ?>" style="<?php echo esc_attr($css); ?>">
                        <tr>
                            <td width="30%">Term Name</td>
                            <td width="70%"><?php echo esc_html($term); ?></td>
                        </tr>
                        <tr class="form-field">
                            <td><?php esc_html_e('Term Image', 'essential-addons-for-woocommerce') ?></td>
                            <td>
                                <?php $term_field = $controller->getCustomFieldsSettings($post_id, $attribute_name, $term, 'term_value');

    $term_field = ($term_field) ? $term_field : '';

    $image      =  $type == 'image' ? $controller->getCustomFieldsSettings($post_id, $attribute_name, $term, 'term_value') : '';
    $image      = ($image) ? wp_get_attachment_image_src($image) : CCPEAW_ASSETS . '/admin/images/product-variation/placeholder.svg';
    $remove_img = ($image) ? 'display:inline' : 'display:none';
    // $image = $image ? $image[0] : WC()->plugin_url() . '/assets/images/placeholder.png';
    $image = $image ? $image[0] : '';
    ?>

                                <div class='ccpeaw-upload-image'>

                                    <div class="tawcvs-term-image-thumbnail" style="float:left;margin-right:10px;">
                                        <img class="i_index_media_img" src="<?php echo(esc_url($image)); ?>" width="60px" height="60px" alt="term-image" /> <?php  ?>
                                    </div>

                                    <div style="line-height:30px;">
                                        <input type="hidden" class="i_index_media" name="<?php echo esc_attr(sanitize_title('image_' . $attribute_name . '_term_' . $term)); ?>" value="<?php echo esc_attr($term_field); ?>">

                                        <button type="button" class="ccpeaw-upload-image-button button " onclick="ccpeaw_upload_icon_image(this,event)">
                                            <img class="ccpeaw-upload-button" src="<?php echo esc_url(CCPEAW_ASSETS . '/admin/images/product-variation/upload.svg') ?>" alt="upload-button">
                                        </button>
                                        <button type="button" style="<?php echo esc_attr($remove_img); ?>" class="ccpeaw_remove_image_button button " onclick="ccpeaw_remove_icon_image(this,event)">
                                            <img class="ccpeaw-remove-button" src="<?php echo esc_url(CCPEAW_ASSETS . '/admin/images/product-variation/remove.svg') ?>" alt="remove-button">
                                        </button>

                                    </div>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>

    <?php
        $i++;
} ?>
</table>