<?php if (! defined('ABSPATH')) {
    exit;
} ?>
<?php
$attribute       = $data['attribute'];
$type            = $data['type'];
$attribute_name  = sanitize_title($attribute->get_name());
$display_status  = $type == 'color' ? 'display: table' : 'display: none';
$controller      = $data['controller'];
$post_id         = $data['post_id'];
?>

<table class="ccpeaw-custom-table ccpeaw-custom-table-color" style="<?php echo esc_attr($display_status); ?>">
    <?php
    $i = 0;
foreach ($attribute->get_options() as $term) {
    $css  = $i == 0 ? 'display:table-row-group' : '';
    $open = $i == 0 ? 'open' : '';
    ?>
        <tr class="ccpeaw-term-name">
            <td colspan="2">
                <h3 class="ccpeaw-local-head <?php echo esc_attr($open); ?>" data-term_name="<?php echo esc_attr($term); ?>" onclick="ccpeaw_open_body(this,event)"><?php echo esc_html($term); ?></h3>
                <table class="ccpeaw-local-body-table">
                    <tbody class="ccpeaw-local-body ccpeaw-local-body-<?php echo esc_attr($term); ?>" style="<?php echo esc_attr($css); ?>">
                        <tr>
                            <td width="30%"><?php esc_html_e('Term Name', 'essential-addons-for-woocommerce') ?></td>
                            <td width="70%"><?php echo esc_html($term); ?></td>
                        </tr>
                        <?php
                        $color_type = $controller->getCustomFieldsSettings($post_id, $attribute_name, $term, 'color_type');
    $color_type                     = $color_type ? $color_type : '';
    ?>

                        <tr>
                            <td>Term Color</td>
                            <td class="th-custom-attr-color-td"><?php
                                            $term_field = $type == 'color' ? $controller->getCustomFieldsSettings($post_id, $attribute_name, $term, 'term_value') : '';
    $term_field                                         = ($term_field) ? $term_field : ''; ?>

                                <div class="ccpeaw_settings_fields_form thwvs-col-div" style="margin-bottom: 5px">
                                    <span class="thpladmin-colorpickpreview color_preview" style="background-color: <?php echo esc_attr($term_field); ?> ;"></span>
                                    <input type="text" name="<?php echo esc_attr(sanitize_title('color_' . $attribute_name . '_term_' . $term)); ?>" class="thpladmin-colorpick" value="<?php echo esc_attr($term_field); ?>" style="width:250px;" />
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>
    <?php
        $i++;
} ?>
</table>