<?php
defined('ABSPATH') || exit; // Ensure WordPress environment

$value    = $data['value'] ?? '';
$image    = esc_url($data['image']);
$label    = esc_html($data['label']);
$taxonomy = esc_attr($data['taxonomy']);

if ($value == 'new') :
    ?>
    <div class="ccpeaw-types gbl-attr-img gbl-attr-terms gbl-attr-terms-new">
        <div class='ccpeaw-upload-image'>
            <label><?php $label; ?></label>
            <div class="tawcvs-term-image-thumbnail">
                <img class="i_index_media_img" src="<?php $image; ?>" width="50" height="50" alt="term-image" />
            </div>
            <div style="line-height:60px;">
                <input type="hidden" class="i_index_media" name="product_<?php $taxonomy; ?>" value="">

                <button type="button" class="ccpeaw-upload-image-button button" onclick="ccpeaw_upload_icon_image(this, event)">
                    <img class="ccpeaw-upload-button" src="<?php echo esc_url(CCPEAW_ASSETS . '/admin/images/product-variation/upload.svg') ?>" alt="upload-button">
                </button>

                <button type="button" style="display:none" class="ccpeaw_remove_image_button button" onclick="ccpeaw_remove_icon_image(this, event)">
                    <img class="ccpeaw-remove-button" src="<?php echo esc_url(CCPEAW_ASSETS . '/admin/images/product-variation/remove.svg') ?>" alt="remove-button">
                </button>
            </div>
        </div>
    </div>
<?php else : ?>
    <tr class="form-field gbl-attr-img gbl-attr-terms gbl-attr-terms-edit">
        <th><?php $label; ?></th>
        <td>
            <div class='ccpeaw-upload-image'>
                <div class="tawcvs-term-image-thumbnail">
                    <img class="i_index_media_img" src="<?php $image; ?>" width="50" height="50" alt="term-image" />
                </div>
                <div style="line-height:60px;">
                    <input type="hidden" class="i_index_media" name="product_<?php $taxonomy; ?>" value="">

                    <button type="button" class="ccpeaw-upload-image-button button" onclick="ccpeaw_upload_icon_image(this, event)">
                        <img class="ccpeaw-upload-button" src="<?php echo esc_url(CCPEAW_ASSETS . '/admin/images/product-variation/upload.svg') ?>" alt="upload-button">
                    </button>

                    <button type="button" style="<?php is_array($value) && !empty($value['term_type_field']) ? '' : 'display:none'; ?>" class="ccpeaw_remove_image_button button" onclick="ccpeaw_remove_icon_image(this, event)">
                        <img class="ccpeaw-remove-button" src="<?php echo esc_url(CCPEAW_ASSETS . '/admin/images/product-variation/remove.svg') ?>" alt="remove-button">
                    </button>
                </div>
            </div>
        </td>
    </tr>
<?php endif; ?>