<?php if (! defined('ABSPATH')) {
    exit;
} ?>
<?php
$saved_settings = $data['saved_settings'];
$type_options   = $data['type_options'];
$attributes     = $data['attributes'];
$thepostid      = $data['thepostid'];
$controller     = $data['controller'];
?>

<div id="ccpeaw-product-attribute-settings" class="panel wc-metaboxes-wrapper hidden">
    <div id="custom_variations_inner">
        <h2><?php esc_html_e('Custom Attribute Settings', 'essential-addons-for-woocommerce'); ?></h2>

        <?php
        $i            = -1;
$has_custom_attribute = false;

foreach ($attributes as $attribute) {
    $attribute_name = sanitize_title($attribute->get_name());
    $type           = '';

    $i++;
    if ($attribute->is_taxonomy() == false) {
        $has_custom_attribute = true;
        ?>
                <div data-taxonomy="<?php echo esc_attr($attribute->get_taxonomy()); ?>" class="woocommerce_attribute wc-metabox closed" rel="<?php echo esc_attr($attribute->get_position()); ?>">

                    <h3>
                        <div class="handlediv" title="<?php esc_attr_e('Click to toggle', 'essential-addons-for-woocommerce'); ?>"></div>
                        <strong class="attribute_name"><?php echo esc_html(wc_attribute_label($attribute_name)); ?></strong>
                    </h3>
                    <div class="ccpeaw_custom_attribute wc-metabox-content <?php echo 'ccpeaw-' . esc_attr($attribute_name); ?> hidden">
                        <table cellpadding="0" cellspacing="0">
                            <tbody>
                                <tr>
                                    <td colspan="2">
                                        <p class="form-row form-row-full">
                                            <label for="custom_attribute_type"><?php esc_html_e('Swatch Type', 'essential-addons-for-woocommerce'); ?></label>
                                            <span class="woocommerce-help-tip" data-tip=" Determines how this custom attribute's values are displayed"></span>

                                            <select name="<?php echo('th_attribute_type_' . esc_attr($attribute_name)); ?>" class="select short th-attr-select" value='' onchange="ccpeaw_change_term_type(this,event)">
                                                <?php
                                                $type = $controller->getCustomFieldsSettings($thepostid, $attribute_name, 'type');

        foreach ($type_options as $key => $value) {
            $default = (isset($type) &&  $type == $key) ? 'selected' : '';
            ?>
                                                    <option value="<?php echo esc_attr($key); ?>" <?php echo esc_html($default) ?>><?php echo esc_html($value); ?></option>
                                                <?php
        } ?>
                                            </select>
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <th></th>
                                </tr>
                                <tr>
                                    <td>
                                        <?php $controller->customAttributeSettingsField($attribute, $thepostid); ?>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php }
    }

if (!$has_custom_attribute) {
    ?>
            <div class="inline notice woocommerce-message">
                <p><?php esc_html_e('No custom attributes added yet.', 'essential-addons-for-woocommerce');
    esc_html_e(' You can add custom attributes from the', 'essential-addons-for-woocommerce'); ?> <a onclick="ccpeawTriggerAttributeTab(this)" href="#woocommerce-product-data"><?php esc_html_e(' Attributes', 'essential-addons-for-woocommerce'); ?> </a> <?php esc_html_e('tab', 'essential-addons-for-woocommerce'); ?></p>
            </div>
        <?php
}
?>
    </div>
</div>