<?php
defined('ABSPATH') || exit; // Ensure WordPress environment

$value = $data['value'] ?? '';
$label = esc_html($data['label'] ?? 'Color');
$name  = esc_attr($data['name'] ?? '');

if ($value === 'new') :
    ?>
    <div class="ccpeaw-types gbl-attr-color gbl-attr-terms gbl-attr-terms-new">
        <label><?php $label; ?></label>
        <div class="ccpeaw_settings_fields_form thwvs-col-div">
            <span class="thpladmin-colorpickpreview color_preview"></span>
            <input type="text" name="<?php $name; ?>" class="thpladmin-colorpick" />
        </div>
    </div>
<?php else : ?>
    <tr class="gbl-attr-terms gbl-attr-terms-edit">
        <th><?php $label; ?></th>
        <td>
            <div class="ccpeaw_settings_fields_form thwvs-col-div">
                <span class="thpladmin-colorpickpreview color_preview" style="background:<?php esc_attr($value); ?>;"></span>
                <input type="text" name="<?php $name; ?>" class="thpladmin-colorpick" value="<?php esc_attr($value); ?>" />
            </div>
        </td>
    </tr>
<?php endif; ?>