<?php if (! defined('ABSPATH')) {
    exit;
} ?>
<?php
$taxonomy           = $data['taxonomy'];
$attribute_taxonomy = $data['attribute_taxonomy'];
$attribute_type     = $data['attribute_type'];
$i                  = $data['i'];
$product_id         = $data['product_id'];
$all_terms          = $data['all_terms'];
?>

<select multiple="multiple" data-placeholder="<?php esc_attr_e('Select terms', 'essential-addons-for-woocommerce'); ?>"
    class="multiselect attribute_values wc-enhanced-select" name="attribute_values[<?php echo esc_attr($i); ?>][]">
    <?php if ($all_terms) :
        foreach ($all_terms as $term) : ?>
            <option value="<?php echo esc_attr($term->term_id); ?>"
                <?php echo esc_html(wc_selected(has_term(absint($term->term_id), $taxonomy, $product_id), true)); ?>>
                <?php echo esc_attr(apply_filters('woocommerce_product_attribute_term_name', $term->name, $term)); ?>
            </option>
    <?php endforeach;
    endif; ?>
</select>

<button class="button plus select_all_attributes"><?php esc_html_e('Select all', 'essential-addons-for-woocommerce'); ?></button>
<button class="button minus select_no_attributes"><?php esc_html_e('Select none', 'essential-addons-for-woocommerce'); ?></button>

<?php if (in_array($attribute_type, ['label', 'image', 'color'])) : ?>
    <button class="button fr plus ccpeaw_add_new_attribute"
        data-attr_taxonomy="<?php echo esc_attr($taxonomy); ?>"
        data-attr_type="<?php echo esc_attr($attribute_type); ?>"
        data-dialog_title="<?php esc_attr_e('Add new', 'essential-addons-for-woocommerce'); ?> <?php echo esc_attr($attribute_taxonomy->attribute_label); ?>">

        <?php esc_html_e('Add new', 'essential-addons-for-woocommerce'); ?>
    </button>
<?php else : ?>
    <button class="button fr plus add_new_attribute"><?php esc_html_e('Add new', 'essential-addons-for-woocommerce'); ?></button>
<?php endif; ?>