<?php
defined('ABSPATH') || exit;
echo esc_html($type);
do_action('woocommerce_before_cart'); ?>

<style>
	.woocommerce-cart-wrapper {
		max-width: 1200px;
		margin: 0 auto;
	}

	.woocommerce-cart-form {
		margin-top: 30px;
	}

	.shop_table {
		width: 100%;
		border-collapse: collapse;
	}

	.shop_table th {
		background-color: #f5f5f5;
		padding: 10px;
		text-align: left;
	}

	.shop_table td {
		padding: 10px;
		border-bottom: 1px solid #ddd;
	}

	.product-remove {
		width: 50px;
		text-align: center;
	}

	.product-thumbnail {
		width: 100px;
	}

	.product-name {
		width: 300px;
	}

	.product-price {
		width: 150px;
		text-align: right;
	}

	.product-quantity {
		width: 150px;
	}

	.product-subtotal {
		width: 150px;
		text-align: right;
	}

	.woocommerce-Price-amount {
		font-weight: bold;
	}

	.quantity {
		display: flex;
		align-items: center;
	}

	.quantity input {
		width: 50px;
		text-align: center;
	}

	.wc-proceed-to-checkout {
		margin-top: 30px;
		text-align: right;
	}

	.wc-proceed-to-checkout a {
		background-color: #007cba;
		color: #fff;
		padding: 10px 20px;
		border-radius: 5px;
		text-decoration: none;
	}
</style>

<div class="woocommerce-cart-wrapper">
	<form class="woocommerce-cart-form" action="<?php echo esc_url(wc_get_cart_url()); ?>" method="post">
		<?php do_action('woocommerce_before_cart_table'); ?>
		<table class="shop_table shop_table_responsive cart woocommerce-cart-form__contents" cellspacing="0">
			<thead>
				<tr>
					<th class="product-remove">&nbsp;</th>
					<th class="product-thumbnail">&nbsp;</th>
					<th class="product-name"><?php esc_html_e('Product', 'essential-addons-for-woocommerce'); ?></th>
					<th class="product-price"><?php esc_html_e('Price', 'essential-addons-for-woocommerce'); ?></th>
					<th class="product-quantity"><?php esc_html_e('Quantity', 'essential-addons-for-woocommerce'); ?></th>
					<th class="product-subtotal"><?php esc_html_e('Subtotal', 'essential-addons-for-woocommerce'); ?></th>
				</tr>
			</thead>
			<tbody>
				<tr class="woocommerce-cart-form__cart-item cart_item">
					<td class="product-remove">
						<?php
                        echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                            'woocommerce_cart_item_remove_link',
                            sprintf(
                                '<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
                                esc_url(wc_get_cart_remove_url(1)),
                                esc_html__('Remove this item', 'essential-addons-for-woocommerce'),
                                esc_attr(1),
                                esc_attr('')
                            ),
                            1
                        );
?>
					</td>

					<td class="product-thumbnail">
						<div class="woocommerce-cart-product-thumbnail">
							<a href="">
								<img width="300" height="300" src="" class="wp-post-image" alt="Product Image" />
							</a>
						</div>
					</td>

					<td class="product-name" data-title="<?php esc_attr_e('Product', 'essential-addons-for-woocommerce'); ?>">
						<a href="">Product Name</a>
					</td>

					<td class="product-price" data-title="<?php esc_attr_e('Price', 'essential-addons-for-woocommerce'); ?>">
						<span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">$</span>10.00</span>
					</td>

					<td class="product-quantity" data-title="<?php esc_attr_e('Quantity', 'essential-addons-for-woocommerce'); ?>">
						<div class="quantity">
							<label class="screen-reader-text" for="quantity_1"><?php esc_html_e('Quantity', 'essential-addons-for-woocommerce'); ?></label>
							<input type="number" id="quantity_1" class="input-text qty text" step="1" min="0" max="" name="cart[1][qty]" value="1" title="Qty" size="4" pattern="[0-9]*" inputmode="numeric" />
						</div>
					</td>

					<td class="product-subtotal" data-title="<?php esc_attr_e('Subtotal', 'essential-addons-for-woocommerce'); ?>">
						<span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">$</span>10.00</span>
					</td>
				</tr>
			</tbody>
		</table>

		<?php do_action('woocommerce_cart_contents'); ?>
		<div class="wc-proceed-to-checkout">
			<?php do_action('woocommerce_proceed_to_checkout'); ?>
			<?php wp_nonce_field('woocommerce-cart', 'woocommerce-cart-nonce'); ?>
		</div>
	</form>

	<?php do_action('woocommerce_after_cart_table'); ?>
</div>

<?php do_action('woocommerce_after_cart'); ?>