<?php

use CodeConfig\EAW\AppSettings;

if (! defined('ABSPATH')) {
    exit;
}
$settings     = $settings ?? AppSettings::getInstance();
$product_id   = $product->get_id();
$product_name = $product->get_name();
$class        = [
    'eaw-sb-container',
    "eaw-sb-container-$template",
    "eaw-sb-container-ps-$position",
    'eaw-sb-container-pd-' . $product->get_type(),
];
$class[]      = is_rtl() ? 'eaw-sb-container-rtl' : '';
$class[]      = $customize_preview ? 'eaw-sb-container-customize_preview' : '';
$class[]      = $always_appear ? 'eaw-sb-container-always_appear' : '';
$class[]      = is_user_logged_in() ? 'eaw-sb-container-logged' : '';
$class        = implode(' ', $class);
?>
<div class="<?php echo esc_attr(trim($class)); ?>">
	<div class="eaw-sb-wrap">
		<div class="eaw-sb-product-desc-wrap">
			<div class="eaw-sb-product-img-wrap">
				<?php
                $product_img_url = wp_get_attachment_image_url(get_post_thumbnail_id($product_id), 'woocommerce_gallery_thumbnail') ?? wc_placeholder_img_src();
echo sprintf('<img src="%s" data-src="%s" class="eaw-sb-product-img" alt="%s">', esc_url($product_img_url), esc_url($product_img_url), wp_kses_post($product_name));
?>
			</div>
			<div class="eaw-sb-product-title-wrap">
				<a href="<?php echo esc_url($product->get_permalink()); ?>"><span class="eaw-sb-product-title"><?php echo esc_html($product_name); ?></span></a>
				<?php
if ($settings->getParams('sbShowRating') || $customize_preview) {
    echo sprintf('<div class="eaw-sb-product-rating-wrap">%s</div>', wc_get_rating_html($product->get_average_rating())); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
}
if (in_array($template, [2, 4])) {
    ?>
					<div class="eaw-sb-product-price-wrap">
						<span class="price">
							<?php echo wp_kses($product->get_price_html(), AppSettings::extendPostAllowedHtml()); ?>
						</span>
					</div>
				<?php
}
?>
			</div>
		</div>
		<?php
        if ($product->is_in_stock()) {
            ?>
			<div class="eaw-sb-product-control">
				<div class="eaw-sb-product-cart">
					<?php do_action('eaw-product-' . $product->get_type() . '-add-to-cart', $product, $template, $settings); ?>
				</div>
			</div>
		<?php
        } else {
            echo sprintf('<div class="eaw-sb-product-oft">%s</div>', wp_kses_post(apply_filters('eaw-set-out-of-stock-text', esc_html__('Out Of Stock', 'essential-addons-for-woocommerce'), $product)));
        }
?>
	</div>
</div>