<?php

use CodeConfig\EAW\AppSettings;

if (! defined('ABSPATH')) {
    exit;
}

$settings      = $settings ?? AppSettings::getInstance()();
$product_id    = $product->get_id();
$product_name  = $product->get_name();
$class         = [
    'eaw-sb-container eaw-sb-container-mobile',
    'eaw-sb-container-ps-' . $position,
    'eaw-sb-container-pd-' . $product->get_type(),
];
$class[]       = is_rtl() ? 'eaw-sb-container-rtl' : '';
$class[]       = is_user_logged_in() ? 'eaw-sb-container-logged' : '';
$popup_class   = $class;
$popup_class[] = 'eaw-sb-container-popup';
$popup_class   = trim(implode(' ', $popup_class));
$class[]       = $always_appear ? 'eaw-sb-container-always_appear' : '';
$class[]       = !empty($customize_preview) ? 'eaw-sb-container-customize_preview eaw-disabled' : '';
$class         = trim(implode(' ', $class));

?>
<div class="<?php echo esc_attr($class); ?>">
	<div class="eaw-sb-wrap">
		<?php
        if ($settings->getParams('sbMobileImg')) {
            ?>
			<div class="eaw-sb-product-img-wrap">
				<?php
                    $product_img_url = wp_get_attachment_image_url(get_post_thumbnail_id($product_id), 'woocommerce_gallery_thumbnail') ?? wc_placeholder_img_src();
            echo sprintf('<img src="%s" data-src="%s" class="eaw-sb-product-img" alt="%s">', esc_url($product_img_url), esc_url($product_img_url), wp_kses_post($product_name));
            ?>
			</div>
		<?php
        }
if ($product->is_in_stock()) {
    do_action('eaw_sb_mobile_button_action', $product);
} else {
    echo sprintf('<div class="eaw-sb-product-oft">%s</div>', wp_kses_post(apply_filters('eaw-set-out-of-stock-text', esc_html__('Out Of Stock', 'essential-addons-for-woocommerce'), $product)));
}
?>
	</div>
</div>
<div class="<?php echo esc_attr($popup_class); ?>">
	<div class="eaw-sb-container-popup-form-wrap">
		<?php do_action('eaw_sb_mobile_' . $product->get_type() . '_add_to_cart', $product); ?>
		<span class="eaw-sb-container-popup-cancel">x</span>
	</div>
	<div class="eaw-sb-container-popup-overlay"></div>
</div>