<?php defined('ABSPATH') || exit('No direct script access allowed');

$productID    = $stickyData['productId'];
$product      = wc_get_product($productID);
$productTitle = get_the_title($productID);

$regularPrice = $product->get_regular_price();
$salePrice    = $product->get_sale_price();
$productPrice = $salePrice ? wc_price($salePrice) : wc_price($regularPrice);

$productImage = has_post_thumbnail($productID) ? get_the_post_thumbnail_url($productID) : wc_placeholder_img_src();

$displayCondition = isset($stickyData['displayCondition']) && is_array($stickyData['displayCondition']) ? $stickyData['displayCondition'] : [];

$deviceClasses = '';
if (!empty($displayCondition)) {
    foreach ($displayCondition as $deviceType) {
        $deviceClasses .= 'eaw-display-' . strtolower($deviceType) . ' ';
    }
    $deviceClasses = rtrim($deviceClasses);
}

$productExcluded = !empty($stickyData['stickyProductExclude']) && in_array($productID, array_column($stickyData['stickyProductExclude'], 'value'));

$categoryExcluded = !empty($stickyData['stickyExcludeCategories']) && array_intersect(wc_get_product_cat_ids($productID), array_column($stickyData['stickyExcludeCategories'], 'value'));

if ($productExcluded || $categoryExcluded) {
    return;
}

// get product type from product id
$stickyProductType = wc_get_product($productID)->get_type();

$groupedProductClass = $stickyProductType === 'grouped' ? ' eaw-product-grouped' : '';
?>
<div class="eaw-sticky-cart-content-wrapper">
    <div class="eaw-sticky-cart-content-wrapper-inner <?php echo esc_attr($deviceClasses); ?>">
        <div class="eaw-sticky-cart-content">
            <div class="eaw-sticky-cart-product">
                <div class="eaw-sticky-cart-product-image">
                    <img src="<?php echo esc_url($productImage); ?>" alt="<?php echo esc_attr($productTitle); ?>">
                </div>
                <div class="eaw-sticky-cart-product-info">
                    <div class="eaw-sticky-cart-product-title">
                        <?php echo esc_html($productTitle); ?>
                    </div>
                    <div class="eaw-sticky-cart-product-price">
                        <?php echo wp_kses_post($productPrice); ?>
                    </div>
                </div>
            </div>
            <div class="eaw-sticky-cart-quantity">
                <?php
                woocommerce_quantity_input([
                    'input_name'   => 'quantity',
                    'input_value'  => 1,
                    'min_value'    => apply_filters('woocommerce_quantity_input_min', 1, $product),
                    'max_value'    => apply_filters('woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product),
                    'product_name' => $productTitle,
                ]);
?>
                <button type="submit" class="button eaw-add-to-cart-product add-to-cart<?php echo esc_attr($groupedProductClass); ?>">
                    <?php echo esc_html($product->single_add_to_cart_text()); ?>
                </button>
            </div>
        </div>
    </div>
</div>