<?php
if (! defined('ABSPATH')) {
    exit;
}
$class           = [
    'eaw-sidebar-cart',
    'eaw-sidebar-cart-' . $scDisplayType = $sidebar_cart->getParams('scDisplayType'),
    'eaw-sidebar-cart-' . $scPosition    = $sidebar_cart->getParams('scPosition'),
];
$class[]         = is_rtl() ? 'eaw-sidebar-cart-rtl' : '';
$scEmptyEnable   = $sidebar_cart->getParams('scEmptyEnable');
if (! $sidebar_cart->is_customize) {
    $class[] = ! $scEmptyEnable && WC()->cart->is_empty() ? 'eaw-disabled' : '';
}
$class = trim(implode(' ', $class));
?>
<div class="eaw-sidebar-cart-wrap" data-empty_enable="<?php echo esc_attr($scEmptyEnable ?: ''); ?>"
     data-cart_icon="<?php echo esc_attr($sidebar_cart->getParams('scIconEnable') ?: ''); ?>"
     data-effect_after_atc="<?php echo esc_attr($sidebar_cart->getParams('scEffectAfterAtc') ?: ''); ?>"
     data-fly_to_cart="<?php echo esc_attr($sidebar_cart->getParams('scFlyToCart') ?: ''); ?>">
    <div class="eaw-sidebar-cart-overlay eaw-disabled"></div>
    <div class="<?php echo esc_attr($class); ?>" data-type="<?php echo esc_attr($scDisplayType); ?>" data-old_position=""
         data-position="<?php echo esc_attr($scPosition); ?>"
         data-effect="<?php echo esc_attr($sidebar_cart->getParams('scTriggerStyle')); ?>">
		<?php
        do_action('eaw_get_sidebar_cart_content');
?>
    </div>
</div>