<?php

use CodeConfig\EAW\App\CartManager\SidebarCartContent;
use CodeConfig\EAW\AppSettings;

if (! defined('ABSPATH')) {
    exit;
}
if (! $wc_cart || $wc_cart->is_empty()) {
    echo sprintf(
        '<li class="eaw-sidebar-cart-pd-empty">%s</li>',
        wp_kses_post(apply_filters('eaw_get_cart_empty_text', esc_html__('No products in the cart.', 'essential-addons-for-woocommerce')))
    );

    return;
}
$settings          = SidebarCartContent::$settings;
$delete_icon       = $sidebar_cart->getParams('scPdDeleteIcon');
$delete_icon_class = $settings->getClassIcon($delete_icon, 'delete_icons');
foreach ($wc_cart->get_cart() as $cart_item_key => $cart_item) {
    $product    = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
    $product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);
    if ($product && $product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_cart_item_visible', true, $cart_item, $cart_item_key)) {
        $product_permalink = apply_filters('woocommerce_cart_item_permalink', $product->is_visible() && $settings->getParams('scPdNameLink') ? $product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
        $product_thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $product->get_image(), $cart_item, $cart_item_key);
        if (is_plugin_active('shopengine/shopengine.php')) {
            $product_thumbnail = $product_thumbnail ?: $product->get_image();
            $product_name      = $product_permalink ? sprintf('<a href="%s" class="eaw-sidebar-cart-pd-name">%s</a>', esc_url($product_permalink), $product->get_name()) : sprintf('<div class="eaw-sidebar-cart-pd-name">%s</div>', $product->get_name());
        } elseif (! $product_permalink) {
            $product_name = apply_filters('woocommerce_cart_item_name', sprintf('<div class="eaw-sidebar-cart-pd-name">%s</div>', $product->get_name()), $cart_item, $cart_item_key);
        } else {
            $product_name = apply_filters('woocommerce_cart_item_name', sprintf('<a href="%s" class="eaw-sidebar-cart-pd-name">%s</a>', esc_url($product_permalink), $product->get_name()), $cart_item, $cart_item_key);
        }
        $attr = [
            'data-cart_item_key' => $cart_item_key,
            'data-product_id'    => $product_id,
        ];
        if (!empty($GLOBALS['gtm4wp_cart_item_proddata'])) {
            $attr['data-gtm4wp_product_id']         = $GLOBALS['gtm4wp_cart_item_proddata']['id']          ?? '';
            $attr['data-gtm4wp_product_name']       = $GLOBALS['gtm4wp_cart_item_proddata']['name']        ?? '';
            $attr['data-gtm4wp_product_price']      = $GLOBALS['gtm4wp_cart_item_proddata']['price']       ?? '';
            $attr['data-gtm4wp_product_cat']        = $GLOBALS['gtm4wp_cart_item_proddata']['category']    ?? '';
            $attr['data-gtm4wp_product_url']        = $GLOBALS['gtm4wp_cart_item_proddata']['productlink'] ?? '';
            $attr['data-gtm4wp_product_variant']    = $GLOBALS['gtm4wp_cart_item_proddata']['variant']     ?? '';
            $attr['data-gtm4wp_product_stocklevel'] = $GLOBALS['gtm4wp_cart_item_proddata']['stocklevel']  ?? '';
            $attr['data-gtm4wp_product_brand']      = $GLOBALS['gtm4wp_cart_item_proddata']['brand']       ?? '';
        }
        $attr           = apply_filters('eaw-sidebar-cart-product-attrs', $attr, $cart_item_key, $product);
        $pd_class_wrap  = apply_filters('eaw-sidebar-cart-product-class', ['eaw-sidebar-cart-pd-wrap'], $cart_item_key, $product);
        ?>
		<li class="<?php echo esc_attr(trim(implode(' ', $pd_class_wrap))) ?>" <?php echo wc_implode_html_attributes($attr); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
        ?>>
			<div class="eaw-sidebar-cart-pd-img-wrap">
				<?php echo $product_permalink ? sprintf('<a href="%s">%s</a>', esc_url($product_permalink), wp_kses_post($product_thumbnail)) : wp_kses_post($product_thumbnail); ?>
			</div>
			<div class="eaw-sidebar-cart-pd-info-wrap">
				<div class="eaw-sidebar-cart-pd-name-wrap">
					<?php
                    echo wp_kses_post($product_name);
        ?>
					<div class="eaw-sidebar-cart-pd-remove-wrap">
						<?php
            echo esc_html(apply_filters(
                'eaw_mini_cart_pd_remove', // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                sprintf(
                    '<a href="%s" class="eaw-sidebar-cart-pd-remove" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s"><i class="%s"></i></a>',
                    esc_url(wc_get_cart_remove_url($cart_item_key)),
                    esc_html__('Remove this item', 'essential-addons-for-woocommerce'),
                    esc_attr($product_id),
                    esc_attr($cart_item_key),
                    esc_attr($product->get_sku()),
                    esc_attr($delete_icon_class)
                ),
                esc_html($cart_item),
                esc_html($cart_item_key)
            ));
        ?>
					</div>
				</div>
				<?php
                $meta_data = wc_get_formatted_cart_item_data($cart_item, true);
        if ($meta_data) {
            ?>
					<div class="eaw-sidebar-cart-pd-meta">
						<?php echo wp_kses($meta_data, $settings::extendPostAllowedHtml()); ?>
					</div>
				<?php
        }
        $scPdDescEnable = $sidebar_cart->getParams('scPdDescEnable');
        if (($scPdDescEnable || is_customize_preview()) && $product->get_short_description()) {
            printf('<div class="eaw-sidebar-cart-pd-desc eaw-sidebar-cart-pd-short-desc%1s">%2s</div>', esc_attr($scPdDescEnable ? '' : ' eaw-disabled'), wp_kses($product->get_short_description(), AppSettings::extendPostAllowedHtml()));
        }
        ?>
				<div class="eaw-sidebar-cart-pd-desc">
					<?php
            if ($product->is_sold_individually()) {
                echo esc_html(apply_filters(
                    'eaw_mini_cart_pd_qty',
                    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                    sprintf('<div class="eaw-sidebar-cart-pd-quantity eaw-hidden"><input type="hidden" name="eaw_cart[%s][qty]" value="1"></div>', esc_attr($cart_item_key)),
                    $cart_item_key,
                    $cart_item,
                    []
                ));
            } else {
                $quantity_args = apply_filters('eaw_quantity_input_args', [
                    'input_name'   => "eaw_cart[{$cart_item_key}][qty]",
                    'input_value'  => $cart_item['quantity'],
                    'max_value'    => $product->get_max_purchase_quantity(),
                    'min_value'    => '0',
                    'classes'      => ['eaw_qty'],
                    'product_name' => $product->get_name()
                ], $product);
                echo apply_filters('eaw_mini_cart_pd_qty', $sidebar_cart::get_sc_pd_quantity_html($quantity_args), $cart_item_key, $cart_item, $quantity_args); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            }
        $scPdPriceStyle = $scPdPriceStyle ?? $settings->getParams('scPdPriceStyle');
        ?>
					<div class="eaw-sidebar-cart-pd-price eaw-sidebar-cart-pd-price-<?php echo esc_attr($scPdPriceStyle); ?>">
						<?php
            echo wp_kses($sidebar_cart::get_sc_pd_price_html($wc_cart, $cart_item, $cart_item_key, $product, $scPdPriceStyle), AppSettings::extendPostAllowedHtml());
        ?>
					</div>
				</div>
			</div>
		</li>
<?php
    }
}
?>