<?php

use CodeConfig\EAW\AppSettings;

if (! defined('ABSPATH')) {
    exit;
}
$settings             = $settings              ?? AppSettings::getInstance();
$is_customize         = $param['is_customize'] ?? $is_customize ?? is_customize_preview();
$checkout_cart_enable = $settings->getParams('scCheckOutCart');
$login_step_enable    = ! (is_user_logged_in() || 'no' === get_option('woocommerce_enable_checkout_login_reminder')) && $settings->getParams('scCheckoutLogin');
$stop_at_login        = ! $is_customize                                                                              && ! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in();
$login_title          = $skip_login_title = '';
if ($login_step_enable) {
    $login_title      = apply_filters('eaw-checkout-login-title', esc_html__('Login', 'essential-addons-for-woocommerce'));
    $skip_login_title = apply_filters('eaw-checkout-skip_login-title', esc_html__('Skip Login', 'essential-addons-for-woocommerce'));
}
if (isset($param['is_paysoncheckout'])) {
    $is_paysoncheckout = $param['is_paysoncheckout'];
} else {
    //	$is_paysoncheckout = class_exists( 'PaysonCheckout_For_WooCommerce_Templates' ) && ( 'paysoncheckout' === WC()->session->get( 'chosen_payment_method' ) || array_search( 'paysoncheckout', WC()->payment_gateways()->get_available_payment_gateways() )===0 );
    $is_paysoncheckout = class_exists('PaysonCheckout_For_WooCommerce_Templates') && array_key_exists('paysoncheckout', WC()->payment_gateways()->get_available_payment_gateways());
}
global $eaw_get_checkout_form;
$eaw_get_checkout_form = 1;
$current_is_checkout   = is_checkout();
?>
<div class="eaw-checkout-step-wrap woocommerce woocommerce-checkout">
	<?php
    if (! $stop_at_login) {
        if (class_exists('WOO_CUSTOM_COUPONS_Frontend_Frontend')) {
            remove_action('woocommerce_before_checkout_form', ['WOO_CUSTOM_COUPONS_Frontend_Frontend', 'display_available_coupons'], 11);
        }
        remove_action('woocommerce_before_checkout_form', 'woocommerce_checkout_login_form', 10);
        remove_action('woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10);
        remove_action('woocommerce_checkout_order_review', 'woocommerce_order_review', 10);
        remove_action('woocommerce_checkout_order_review', 'woocommerce_checkout_payment', 20);
        remove_action('woocommerce_before_checkout_form', 'neobeat_add_main_woo_page_holder', 5);
        remove_action('woocommerce_after_checkout_form', 'neobeat_add_main_woo_page_holder_end', 20);
        global $avada_woocommerce;
        if ($avada_woocommerce) {
            remove_action('woocommerce_before_checkout_form', [$avada_woocommerce, 'checkout_coupon_form'], 10);
            remove_action('woocommerce_before_checkout_form', [$avada_woocommerce, 'avada_top_user_container'], 1);
            remove_action('woocommerce_before_checkout_form', [$avada_woocommerce, 'before_checkout_form'], 10);
            remove_action('woocommerce_before_checkout_form', [$avada_woocommerce, 'before_checkout_form'], 10);
            remove_action('woocommerce_after_checkout_form', [$avada_woocommerce, 'after_checkout_form'], 10);
            remove_action('woocommerce_checkout_before_customer_details', [$avada_woocommerce, 'checkout_before_customer_details'], 10);
            remove_action('woocommerce_checkout_after_customer_details', [$avada_woocommerce, 'checkout_after_customer_details'], 10);
            remove_action('woocommerce_checkout_after_order_review', [$avada_woocommerce, 'checkout_after_order_review'], 20);
            remove_action('woocommerce_checkout_billing', [$avada_woocommerce, 'checkout_billing'], 20);
            remove_action('woocommerce_checkout_shipping', [$avada_woocommerce, 'checkout_shipping'], 20);
        }
        $swap_payment_review = apply_filters('eaw-swap-payment-review', $swap_payment_review ?? false);
        $steps               = [
            'billing'      => [
                'priority' => 0,
            ],
            'shipping'     => [
                'priority' => 1,
            ],
            'order_review' => [
                'priority' => 2,
            ],
            'payment'      => [
                'priority' => 3,
            ],
        ];
        if ($is_paysoncheckout) {
            $param['scCheckoutOrderPayment'] = true;
        }
        $language            = $language ?? $param['language'] ?? '';
        if ($settings->getParams('scCheckOutCart')) {
            if (! $checkout->get_checkout_fields() || $is_paysoncheckout) {
                unset($steps['billing'], $steps['shipping'], $steps['payment']);
                $steps['order_review']['elements'] = $swap_payment_review ? [
                    'payment',
                    'order_review'
                ] : ['order_review', 'payment'];
                $steps['order_review']['class']    = 'eaw-checkout-step-order-payment';
                $steps['order_review']['title']    = $param['scCheckoutOrderPaymentTitle'] ?? $settings->getParams('scCheckoutOrderPaymentTitle', $language);
            } else {
                unset($steps['shipping'], $steps['order_review'], $steps['payment']);
                $steps['billing']['elements'] = ['billing', 'shipping', 'order_review', 'payment'];
                $steps['billing']['class']    = 'eaw-checkout-step-all';
                $steps['billing']['title']    = '';
            }
        } else {
            if (! $checkout->get_checkout_fields() || $is_paysoncheckout) {
                unset($steps['billing'], $steps['shipping']);
            } elseif ($param['scCheckoutBillingShipping'] ?? $settings->getParams('scCheckoutBillingShipping')) {
                unset($steps['shipping']);
                $steps['billing']['elements'] = ['billing', 'shipping'];
                $steps['billing']['class']    = 'eaw-checkout-step-billing-shipping';
                $steps['billing']['title']    = $param['scCheckoutBillingShippingTitle'] ?? $settings->getParams('scCheckoutBillingShippingTitle', $language);
            } else {
                $steps['billing']['title']  = $param['scCheckoutBillingTitle']  ?? $settings->getParams('scCheckoutBillingTitle', $language);
                $steps['shipping']['title'] = $param['scCheckoutShippingTitle'] ?? $settings->getParams('scCheckoutShippingTitle', $language);
            }
            if ($param['scCheckoutOrderPayment'] ?? $settings->getParams('scCheckoutOrderPayment')) {
                unset($steps['payment']);
                $steps['order_review']['elements'] = $swap_payment_review ? [
                    'payment',
                    'order_review'
                ] : ['order_review', 'payment'];
                $steps['order_review']['class']    = 'eaw-checkout-step-order-payment';
                $steps['order_review']['title']    = $param['scCheckoutOrderPaymentTitle'] ?? $settings->getParams('scCheckoutOrderPaymentTitle', $language);
            } else {
                $steps['order_review']['title'] = $param['scCheckoutOrderReviewTitle'] ?? $settings->getParams('scCheckoutOrderReviewTitle');
                $steps['payment']['title']      = $param['scCheckoutPaymentTitle']     ?? $settings->getParams('scCheckoutPaymentTitle', $language);
                if ($swap_payment_review) {
                    $payment_ps                        = $steps['payment']['priority'];
                    $steps['payment']['priority']      = $steps['order_review']['priority'];
                    $steps['order_review']['priority'] = $payment_ps;
                }
            }
        }
        $steps = apply_filters('eaw-checkout-steps', $steps);
        // uasort($steps, 'eaw_sort_array');
        if (!$settings->getParams('scCheckOutCart') && ($settings->getParams('scCheckoutNavBar') || $is_customize)) {
            echo sprintf('<div class="eaw-checkout-nav-step-wrap%s">', $settings->getParams('scCheckoutNavBar') ? '' : esc_attr(' eaw-disabled'));
            if ($login_step_enable) {
                echo sprintf('<div class="eaw-checkout-nav-step" data-step="login" data-step_title="%s" data-next_title="%s"></div>', esc_attr($login_title), esc_attr($skip_login_title));
            }
            foreach ($steps as $step => $value) {
                echo sprintf('<div class="eaw-checkout-nav-step" data-step="%s" data-step_title="%s"></div>', esc_attr($step), $value['title'] ? esc_attr($value['title']) : '');
            }
            echo sprintf('</div>');
        }
    }
if ($login_step_enable) {
    ?>
		<div class="eaw-checkout-step eaw-checkout-step-login" data-step_title="<?php echo esc_attr($login_title); ?>" data-next_title="<?php echo esc_attr($skip_login_title); ?>">
			<div class="eaw-checkout-login">
				<?php
                woocommerce_login_form(
                    [
                        'message'  => esc_html__('If you have shopped with us before, please enter your details below. If you are a new customer, please proceed to the Billing section.', 'essential-addons-for-woocommerce'),
                        'redirect' => wc_get_checkout_url(),
                        'hidden'   => false,
                    ]
                );
    ?>
			</div>
		</div>
	<?php
}
if ($stop_at_login) {
    echo sprintf(
        '<div class="eaw-checkout-login-notice%s">%s</div>',
        ! $login_step_enable ? esc_attr(' eaw-checkout-login-notice-warning') : '',
        wp_kses_post(apply_filters('woocommerce_checkout_must_be_logged_in_message', esc_html__('You must be logged in to checkout.', 'essential-addons-for-woocommerce')))
    );
    echo sprintf('</div>');

    return false;
}
?>
	<div class="eaw-checkout-before-checkout-form eaw-disabled">
		<?php do_action('eaw_before_checkout_form', $checkout); ?>
		<?php do_action('woocommerce_before_checkout_form', $checkout); ?>
	</div>
	<?php
printf('<form name="checkout" method="post" class="checkout woocommerce-checkout" action="%s" enctype="multipart/form-data">', esc_url(wc_get_checkout_url()));
foreach ($steps as $step => $value) {
    $class   = ['eaw-checkout-step eaw-checkout-step-' . $step];
    $class[] = $value['class'] ?? '';
    $class   = trim(implode(' ', $class));
    printf('<div class="%s" data-step_title="%s">', esc_attr($class), $value['title'] ? esc_attr($value['title']) : '');
    if (! empty($value['elements'])) {
        foreach ($value['elements'] as $element) {
            echo sprintf('<div class="eaw-checkout-%s">', esc_attr($element));
            do_action('eaw_checkout_step_' . $element);
            echo sprintf('</div>');
        }
    } else {
        do_action('eaw_checkout_step_' . $step);
    }
    printf('</div>');
}
printf('</form>');
?>
	<div class="eaw-checkout-after-checkout-form eaw-disabled">
		<?php do_action('woocommerce_after_checkout_form', $checkout); ?>
	</div>
</div>