<?php

use CodeConfig\EAW\AppSettings;
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
$class = ['eaw-sidebar-cart-content-close', 'eaw-sidebar-cart-content-wrap'];
$is_customize = $sidebar_cart::is_customize_preview();
$checkout_enable = $sidebar_cart->sidebar_checkout_assign_page();
$checkout_cart_enable = $sidebar_cart->getParams( 'scCheckOutCart' );
$class[] = ( $checkout_enable || $is_customize ? 'eaw-sidebar-cart-content-wrap-checkout' : '' );
$class[] = ( $is_customize ? 'eaw-sidebar-cart-content-wrap-customize' : '' );
$class[] = ( is_user_logged_in() ? 'eaw-sidebar-cart-content-wrap-logged' : '' );
$class = trim( implode( ' ', $class ) );
$wc_cart = WC()->cart;
do_action( 'eaw_before_mini_cart' );
$language = $sidebar_cart::get_language();
$last_applied_coupon = '';
$scFootCoupon = $sidebar_cart->getParams( 'scFootCoupon' );
$scFootCoupon_html = '';
if ( wc_coupons_enabled() && $wc_cart && !$wc_cart->is_empty() ) {
    $applied_coupons = ( method_exists( $wc_cart, 'get_applied_coupons' ) ? $wc_cart->get_applied_coupons() : '' );
    if ( !empty( $applied_coupons ) ) {
        $last_applied_coupon = $applied_coupons[count( $applied_coupons ) - 1];
    }
}
$scFootCartTotal = ( $sidebar_cart->getParams( 'scFootCartTotal' ) ?: 'total' );
$settings_html = [
    'scFootCoupon'    => $scFootCoupon,
    'scFootCartTotal' => $scFootCartTotal,
    'scPdPriceStyle'  => $sidebar_cart->getParams( 'scPdPriceStyle' ),
];
$settings_json = wp_json_encode( $settings_html );
$settings_attr = ( function_exists( 'wc_esc_json' ) ? wc_esc_json( $settings_json ) : _wp_specialchars(
    $settings_json,
    ENT_QUOTES,
    'UTF-8',
    true
) );
?>
<div class="<?php 
echo esc_attr( $class );
?>" data-option="<?php 
echo esc_attr( $settings_attr );
?>">
	<div class="eaw-sidebar-cart-header-wrap">
		<div class="eaw-sidebar-cart-header-title-wrap">
			<?php 
echo wp_kses_post( $sidebar_cart->getParams( 'scHeaderTitle', $language ) );
?>
		</div>
		<?php 
if ( $is_customize || $sidebar_cart::$settings->getParams( 'scHeaderCouponEnable' ) ) {
    if ( $last_applied_coupon ) {
        $last_applied_coupon_t = $last_applied_coupon;
    } else {
        $last_applied_coupon_t = esc_attr__( 'Coupon code', 'essential-addons-for-woocommerce' );
    }
    ?>
			<div class="eaw-sidebar-cart-header-coupon-wrap">
				<input type="text" name="coupon_code" id="coupon_code" class="eaw-coupon-code"
					placeholder="<?php 
    echo esc_attr( $last_applied_coupon_t );
    ?>">
				<button type="submit" class="button eaw-bt-coupon-code" name="apply_coupon">
					<?php 
    printf( '%s', esc_html( apply_filters( 'eaw_get_bt_coupon_text', esc_html__( 'Apply', 'essential-addons-for-woocommerce' ) ) ) );
    ?>
				</button>
			</div>
		<?php 
}
?>
		<div class="eaw-sidebar-cart-close-wrap">
			<i class="eaw_cart_icon-clear-button"></i>
		</div>
	</div>
	<div class="eaw-sidebar-cart-content-wrap1 eaw-sidebar-cart-products-wrap">
		<?php 
do_action( 'eaw_before_mini_cart_content' );
?>
		<ul class="eaw-sidebar-cart-products">
			<?php 
$sidebar_cart::get_sidebar_content_pd_html( $wc_cart );
?>
		</ul>
		<?php 
do_action( 'eaw_after_mini_cart_content' );
if ( ($checkout_enable || $is_customize) && $checkout_cart_enable ) {
    do_action(
        'eaw_get_checkout_form',
        $sidebar_cart,
        $checkout_cart_enable,
        $language,
        '',
        $is_customize
    );
}
?>
	</div>
	<?php 
if ( ($checkout_enable || $is_customize) && !$checkout_cart_enable ) {
    $scCheckOutKeyboardNav = ( $sidebar_cart->getParams( 'scCheckOutKeyboardNav' ) ?: '' );
    do_action(
        'eaw_get_checkout_form',
        $sidebar_cart,
        $checkout_cart_enable,
        $language,
        $scCheckOutKeyboardNav,
        $is_customize
    );
}
?>
	<div class="eaw-sidebar-cart-footer-wrap">
		<?php 
if ( $is_customize || $scFootCoupon ) {
    ?>
			<div class="eaw-sidebar-cart-footer eaw-sidebar-cart-footer-products">
				<div class="eaw-sidebar-cart-footer-coupons<?php 
    echo esc_attr( ( $scFootCoupon_html ? '' : ' eaw-disabled' ) );
    ?>">
					<div class="eaw-sidebar-cart-footer-coupons1">
						<?php 
    echo wp_kses( $scFootCoupon_html, AppSettings::extendPostAllowedHtml() );
    ?>
					</div>
				</div>
			</div>
		<?php 
}
?>
		<div class="eaw-sidebar-cart-footer eaw-sidebar-cart-footer-products">
			<?php 
$scFootCartTotalTitle = $sidebar_cart->getParams( 'scFootCartTotalText', $language );
$scFootButton = ( $sidebar_cart->getParams( 'scFootButton' ) ?: 'cart' );
if ( $is_customize ) {
    ?>
				<div class="eaw-sidebar-cart-footer-cart_total-wrap">
					<div class="eaw-sidebar-cart-footer-cart_total eaw-sidebar-cart-footer-total<?php 
    echo esc_attr( ( $scFootCartTotal === 'total' ? '' : ' eaw-disabled' ) );
    ?>"
						data-cart_total="<?php 
    echo esc_attr( $cart_total = $wc_cart->get_total() );
    ?>">
						<div class="eaw-sidebar-cart-footer-cart_total-title"><?php 
    echo wp_kses_post( $scFootCartTotalTitle );
    ?></div>
						<div class="eaw-sidebar-cart-footer-cart_total1">
							<?php 
    echo wp_kses_post( $cart_total );
    ?>
						</div>
					</div>
					<div class="eaw-sidebar-cart-footer-cart_total eaw-sidebar-cart-footer-subtotal<?php 
    echo esc_attr( ( $scFootCartTotal !== 'total' ? '' : ' eaw-disabled' ) );
    ?>"
						data-cart_total="<?php 
    echo esc_attr( $cart_subtotal = $wc_cart->get_cart_subtotal() );
    ?>">
						<div class="eaw-sidebar-cart-footer-cart_total-title"><?php 
    echo wp_kses_post( $scFootCartTotalTitle );
    ?></div>
						<div class="eaw-sidebar-cart-footer-cart_total1">
							<?php 
    echo wp_kses_post( $cart_subtotal );
    ?>
						</div>
					</div>
				</div>
				<div class="eaw-sidebar-cart-footer-action">
					<button class="eaw-sidebar-cart-bt eaw-sidebar-cart-bt-update button">
						<?php 
    echo wp_kses_post( apply_filters( 'eaw_get_bt_update_text', esc_html__( 'Update Cart', 'essential-addons-for-woocommerce' ) ) );
    ?>
					</button>
					<?php 
    if ( $checkout_cart_enable ) {
        $place_order_text = $sidebar_cart->getParams( 'scCheckoutBtPlaceOrderTitle', $language );
        ?>
						<button class="eaw-sidebar-cart-bt eaw-sidebar-cart-bt-checkout eaw-sidebar-cart-bt-checkout-place_order button"
							data-place_order_text="<?php 
        echo esc_attr( $place_order_text );
        ?>">
							<?php 
        echo wp_kses_post( $place_order_text );
        ?>
						</button>
					<?php 
    } else {
        ?>
						<a href="<?php 
        echo esc_attr( esc_url( get_permalink( wc_get_page_id( 'cart' ) ) ) );
        ?>"
							class="button eaw-sidebar-cart-bt eaw-sidebar-cart-bt-nav eaw-sidebar-cart-bt-nav-cart<?php 
        echo esc_attr( ( $scFootButton === 'cart' ? '' : ' eaw-disabled' ) );
        ?>">
							<?php 
        echo wp_kses_post( $sidebar_cart->getParams( 'scFootBtCartText', $language ) );
        ?>
						</a>
						<?php 
        ?>
					<?php 
    }
    ?>
				</div>
			<?php 
} else {
    ?>
				<div class="eaw-sidebar-cart-footer-cart_total-wrap">
					<div class="eaw-sidebar-cart-footer-cart_total eaw-sidebar-cart-footer-<?php 
    echo esc_attr( $scFootCartTotal );
    ?>">
						<div class="eaw-sidebar-cart-footer-cart_total-title"><?php 
    echo wp_kses_post( $scFootCartTotalTitle );
    ?></div>
						<div class="eaw-sidebar-cart-footer-cart_total1 eaw-sidebar-cart-footer-cart_total1-<?php 
    echo esc_attr( $scFootCartTotal );
    ?>">
							<?php 
    echo ( $scFootCartTotal === 'total' ? wp_kses_post( $wc_cart->get_cart_total() ) : wp_kses_post( $wc_cart->get_cart_subtotal() ) );
    ?>
						</div>
					</div>
				</div>
				<div class="eaw-sidebar-cart-footer-action">
					<button class="eaw-sidebar-cart-bt eaw-sidebar-cart-bt-update eaw-disabled button">
						<?php 
    echo wp_kses_post( apply_filters( 'eaw_get_bt_update_text', __( 'Update Cart', 'essential-addons-for-woocommerce' ) ) );
    ?>
					</button>
					<?php 
    if ( $checkout_enable && $checkout_cart_enable ) {
        $place_order_text = $sidebar_cart->getParams( 'scCheckoutBtPlaceOrderTitle', $language );
        ?>
						<button class="eaw-sidebar-cart-bt eaw-sidebar-cart-bt-checkout eaw-sidebar-cart-bt-checkout-place_order button"
							data-place_order_text="<?php 
        echo esc_attr( $place_order_text );
        ?>">
							<?php 
        echo wp_kses_post( $place_order_text );
        ?>
						</button>
					<?php 
    } elseif ( $checkout_enable && ccpeaw_fs()->can_use_premium_code__premium_only() ) {
        ?>
						<button class="button eaw-sidebar-cart-bt eaw-sidebar-cart-bt-nav eaw-sidebar-cart-bt-nav-checkout">
							<?php 
        echo wp_kses_post( $sidebar_cart::$settings->getParams( 'scFootBtCheckoutText', $language ) );
        ?>
						</button>
						<?php 
    } else {
    }
    ?>
				</div>
			<?php 
}
?>
		</div>
		<?php 
if ( ($checkout_enable || $is_customize) && !$checkout_cart_enable ) {
    $place_order_text = $sidebar_cart->getParams( 'scCheckoutBtPlaceOrderTitle', $language );
    $bt_next_text = $sidebar_cart->getParams( 'scCheckoutBtNextTitle', $language );
    $bt_pre_text = $sidebar_cart->getParams( 'scCheckoutBtPreTitle', $language );
    ?>
			<div class="eaw-sidebar-cart-footer eaw-sidebar-cart-footer-checkout eaw-disabled">
				<button class="eaw-sidebar-cart-bt eaw-sidebar-cart-bt-checkout eaw-sidebar-cart-bt-checkout-place_order button eaw-disabled"
					data-place_order_text="<?php 
    echo esc_attr( $place_order_text );
    ?>">
					<?php 
    echo wp_kses_post( $place_order_text );
    ?>
				</button>
				<button class="eaw-sidebar-cart-bt eaw-sidebar-cart-bt-checkout eaw-sidebar-cart-bt-checkout-nav eaw-sidebar-cart-bt-checkout-next button eaw-disabled"
					data-next_text="<?php 
    echo esc_attr( $bt_next_text );
    ?>">
					<?php 
    echo wp_kses_post( $bt_next_text );
    ?>
				</button>
				<button class="eaw-sidebar-cart-bt eaw-sidebar-cart-bt-checkout eaw-sidebar-cart-bt-checkout-nav eaw-sidebar-cart-bt-checkout-back button eaw-disabled"
					data-pre_text="<?php 
    echo esc_attr( $bt_pre_text );
    ?>">
					<?php 
    echo wp_kses_post( $bt_pre_text );
    ?>
				</button>
				<?php 
    if ( $sidebar_cart::$settings->getParams( 'scCheckoutBtBtcEnable' ) || $is_customize ) {
        $scCheckoutBtBtcTitle = $sidebar_cart->getParams( 'scCheckoutBtBtcTitle', $language );
        $back_icon_class = ( $sidebar_cart::$settings->getClassIcon( $sidebar_cart->getParams( 'scCheckoutBtBtcIcon' ), 'back_icons' ) ?: '' );
        $scCheckoutBtBtcTitle = str_replace( '{back_icon}', '<i class="eaw-sc-checkout-bt-btc-back_icons ' . $back_icon_class . '"></i>', $scCheckoutBtBtcTitle );
        ?>
					<button class="eaw-sidebar-cart-bt eaw-sidebar-cart-bt-checkout eaw-sidebar-cart-bt-checkout-cancel button">
						<?php 
        echo wp_kses_post( $scCheckoutBtBtcTitle );
        ?>
					</button>
				<?php 
    }
    ?>
			</div>
		<?php 
}
?>
		<div class="eaw-sidebar-cart-footer-message-wrap">
			<?php 
$sidebar_cart::get_scFootMsg_html( $sidebar_cart->getParams( 'scFootMsg' ), true );
?>
		</div>
	</div>
	<div class="eaw-sidebar-cart-loading-wrap eaw-disabled">
		<?php 
$scLoading = $sidebar_cart::$settings->getParams( 'scLoading' );
if ( $is_customize ) {
    $loading = [
        'default',
        'dual_ring',
        'animation_face_1',
        'animation_face_2',
        'ring',
        'roller',
        'loader_balls_1',
        'loader_balls_2',
        'loader_balls_3',
        'ripple',
        'spinner'
    ];
    foreach ( $loading as $item ) {
        $sidebar_cart->get_sidebar_loading( $item );
    }
} elseif ( $scLoading ) {
    $sidebar_cart->get_sidebar_loading( $scLoading );
}
?>
	</div>
</div>
<?php 
do_action( 'eaw_after_mini_cart' );