<?php

namespace CodeConfig\EAW\Utils;

defined('ABSPATH') || exit('No direct script access allowed');

trait Singleton
{
    protected static $instance = null;

    /**
     * Private constructor to prevent direct instantiation.
     */
    public function __construct()
    {
        // Prevent instantiation.
    }

    /**
     * Returns an instance of the class. If the class has not yet been instantiated, it will be instantiated first.
     *
     * @return static
     */
    final public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static();
            static::$instance->doHooks();
        }

        return static::$instance;
    }

    /**
     * Method to set up hooks for the class.
     * This function should be overridden in the class using this trait
     * to add necessary action and filter hooks.
     */
    protected function doHooks()
    {
    }
}
