<?php

namespace CodeConfig\EAW;

defined('ABSPATH') || exit('No direct script access allowed');

use CodeConfig\EAW\Utils\Helpers;
use CodeConfig\EAW\Utils\Singleton;

class Update
{
    use Singleton;

    private static $updateList = [];

    public function isUpdateAvailable($version = CCPEAW_VERSION)
    {
        $installedVersion = Helpers::getInstalledVersion();
        if (empty($installedVersion)) {
            return false;
        }

        if (version_compare($version, $installedVersion, '>')) {
            return true;
        }

        return false;
    }

    public function performUpdates()
    {
        foreach (self::$updateList as $version) {
            if ($this->isUpdateAvailable($version)) {
                $file_path = CCPEAW_UPDATES . "/Version_$version.php";

                if (file_exists($file_path)) {
                    include_once $file_path;
                }

                update_option('ccpeaw_version', $version);
            }
        }

        delete_option('ccpeaw_version');
        update_option('ccpeaw_version', CCPEAW_VERSION);
    }
}
