<?php

namespace CodeConfig\EAW;

defined( 'ABSPATH' ) || exit( 'No direct script access allowed' );
use CodeConfig\EAW\Utils\Singleton;
class CodeConfig {
    use Singleton;
    public function __construct() {
        $this->init();
        Enqueue::getInstance();
        Admin::getInstance();
        Ajax::getInstance();
        AppSettings::getInstance();
        Integrations::getInstance();
    }

    private function init() {
        register_activation_hook( CCPEAW_FILE, ['CodeConfig\\EAW\\Activation', 'init'] );
        register_deactivation_hook( CCPEAW_FILE, ['CodeConfig\\EAW\\Deactivation', 'init'] );
    }

    /**
     * Adds hooks to the WordPress hooks system.
     *
     * @return void
     */
    private function doHooks() {
        add_filter(
            'plugin_row_meta',
            [$this, 'pluginRowMeta'],
            10,
            2
        );
    }

    /**
     * Adds a link to the plugin's row meta in the WordPress plugin list.
     *
     * The link points to the plugin's documentation page.
     *
     * @param array $links The current links in the plugin row meta.
     * @param string $file The path to the plugin's main file.
     *
     * @return array The updated links in the plugin row meta.
     */
    public function pluginRowMeta( $links, $file ) {
        if ( $file == plugin_basename( CCPEAW_FILE ) ) {
            $links[] = sprintf( '<a target="_blank" href="%s">%s</a>', CCPEAW_DOCUMENTATION_URL, __( 'Docs & FAQs', 'essential-addons-for-woocommerce' ) );
        }
        return $links;
    }

}
