<?php

namespace CodeConfig\EAW;

use CodeConfig\EAW\App\CartManager\AddToCartButton;
use CodeConfig\EAW\App\CartManager\CustomQuantity;
use CodeConfig\EAW\App\CartManager\Frontend;
use CodeConfig\EAW\App\CartManager\MenuCart;
use CodeConfig\EAW\App\CartManager\SidebarCartContent;
use CodeConfig\EAW\App\CartManager\SidebarCartIcon;
use CodeConfig\EAW\App\CartManager\StickyBar;
use CodeConfig\EAW\App\CartManager\VariableATC;
use CodeConfig\EAW\App\CartManager\ViewedProducts;
use CodeConfig\EAW\App\GallerySlider;
use CodeConfig\EAW\App\QuickView;
use CodeConfig\EAW\App\SaveCart;
use CodeConfig\EAW\App\Tabs;
use CodeConfig\EAW\App\WishList;
use CodeConfig\EAW\Integrations\Gutenberg__premium_only\Blocks;
use CodeConfig\EAW\Utils\Helpers;
use CodeConfig\EAW\Utils\Singleton;
defined( 'ABSPATH' ) || exit( 'No direct script access allowed' );
class AppSettings {
    use Singleton;
    private $params;

    private $default;

    private $classIcons;

    public function doHooks() {
        if ( !$this->params || !$this->default || !$this->classIcons ) {
            $this->default = ccpeaw_default_settings();
            $eaw_settings = Helpers::getSettings();
            $this->params = wp_parse_args( $eaw_settings, $this->default );
            $this->classIcons = ccpeaw_icon_classes();
        }
        $this->init();
    }

    public function getDefaultParams() {
        return $this->params;
    }

    public function init() {
        AddToCartButton::getInstance();
        QuickView::getInstance();
        if ( $this->params['enableViewWishlist'] == '1' ) {
            WishList::getInstance();
        }
        SaveCart::getInstance();
        CustomQuantity::getInstance();
        Tabs::getInstance();
        if ( $this->params['enableGallerySlider'] ) {
            GallerySlider::getInstance();
        }
        // Customizer__premium_only
        Frontend::getInstance();
        AddToCartButton::getInstance();
        StickyBar::getInstance();
        MenuCart::getInstance();
        SidebarCartIcon::getInstance();
        VariableATC::getInstance();
        ViewedProducts::getInstance();
        SidebarCartContent::getInstance();
    }

    public function enable( $prefix ) {
        if ( !$prefix ) {
            return false;
        }
        if ( !$this->getParams( 'enable' . $prefix ) ) {
            return false;
        }
        if ( function_exists( 'wp_is_mobile' ) && wp_is_mobile() && !$this->getParams( $prefix . 'MobileEnable' ) ) {
            return false;
        }
        return true;
    }

    public function getParams( $name = "", $language = '' ) {
        if ( !$name ) {
            return apply_filters( 'ccpeaw_settings', $this->params );
        }
        if ( $language && strpos( $language, '_' ) !== 0 ) {
            $language = '_' . $language;
        }
        $name_t = $name . $language;
        return apply_filters( 'ccpeaw_settings_params_' . $name_t, $this->params[$name_t] ?? $this->params[$name] ?? false );
    }

    public static function getClassIcons( $type = '' ) {
        if ( !$type ) {
            return self::getInstance()->classIcons;
        }
        return self::getInstance()->classIcons[$type] ?? [];
    }

    public static function getClassIcon( $index = 0, $type = '' ) {
        if ( !$type ) {
            return false;
        }
        $icons = self::getInstance()->getClassIcons( $type ) ?? [];
        if ( empty( $icons ) ) {
            return false;
        } else {
            return $icons[$index] ?? $icons[0];
        }
    }

    public function getDefault( $name = "" ) {
        if ( !$name ) {
            return $this->default;
        } elseif ( isset( $this->default[$name] ) ) {
            return apply_filters( 'ccpeaw_params_default-' . $name, $this->default[$name] );
        } else {
            return false;
        }
    }

    public function addInlineStyle(
        $element,
        $name,
        $style,
        $suffix = ''
    ) {
        if ( !$element || !is_array( $element ) ) {
            return '';
        }
        $element = implode( ',', $element );
        $return = $element . '{';
        if ( is_array( $name ) && count( $name ) ) {
            foreach ( $name as $key => $value ) {
                $get_value = $this->getParams( $value );
                $get_suffix = $suffix[$key] ?? '';
                $return .= $style[$key] . ':' . $get_value . $get_suffix . ';';
            }
        }
        $return .= '}';
        return $return;
    }

    public static function extendPostAllowedHtml() {
        return array_merge( wp_kses_allowed_html( 'post' ), [
            'input' => [
                'type'         => 1,
                'id'           => 1,
                'name'         => 1,
                'class'        => 1,
                'placeholder'  => 1,
                'autocomplete' => 1,
                'style'        => 1,
                'value'        => 1,
                'data-*'       => 1,
                'size'         => 1,
            ],
            'form'  => [
                'type'   => 1,
                'id'     => 1,
                'name'   => 1,
                'class'  => 1,
                'style'  => 1,
                'method' => 1,
                'action' => 1,
                'data-*' => 1,
            ],
            'style' => [
                'id'    => 1,
                'class' => 1,
                'type'  => 1,
            ],
            'svg'   => [
                'xmlns'   => 1,
                'viewBox' => 1,
                'width'   => 1,
                'height'  => 1,
            ],
            'path'  => [
                'fill' => 1,
                'd'    => 1,
            ],
        ] );
    }

}
