<?php

namespace CodeConfig\EAW\Ajax;

use CodeConfig\EAW\Utils\Helpers;

defined('ABSPATH') || exit('No direct script access allowed');

class Wishlist
{
    public static function handleWishlist()
    {

        check_ajax_referer('ccpeaw', 'eaw_nonce');

        $productId = isset($_POST['productId']) ? sanitize_text_field(wp_unslash($_POST['productId'])) : null;

        $user_id = get_current_user_id();

        $wishlist = get_user_meta($user_id, 'ccpeaw_wishlist', true);

        if (in_array($productId, $wishlist)) {
            wp_send_json_error([
                'message' => __('Product already in wishlist.', 'essential-addons-for-woocommerce'),
                'success' => false
            ]);
        }

        $addedProducts = Helpers::setWishlist($productId);

        wp_send_json_success([
            'success'  => true,
            'message'  => __('Product added to wishlist successfully', 'essential-addons-for-woocommerce'),
            'wishlist' => $addedProducts,
        ]);
    }

    public static function noPrevSetWishlist()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        wp_send_json_error([
            'message' => __('You must be logged in to add products to the wishlist', 'essential-addons-for-woocommerce'),
            'success' => false
        ]);
    }

    public static function getWishlist()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        $user_id = get_current_user_id();

        if (!is_user_logged_in()) {
            wp_send_json_error([
                'message' => __('You must be logged in to view the wishlist', 'essential-addons-for-woocommerce'),
                'success' => false
            ]);
        }

        $wishlist = get_user_meta($user_id, 'ccpeaw_wishlist', true);

        if (!is_array($wishlist) || empty($wishlist)) {
            wp_send_json_error([
                'message' => __('No wishlist found', 'essential-addons-for-woocommerce'),
                'success' => false
            ]);
        }

        $products = wc_get_products([
            'include' => $wishlist,
            'limit'   => 100,
        ]);

        foreach ($products as $key => $product) {
            $products[$key] = $product->get_data();
        }

        $html = '';

        $html .= '<div class="ccpeaw-wishlist">';
        foreach ($products as $product) {
            $html .= '<div class="ccpeaw-wishlist-item">' . '<a href="' . get_the_permalink($product['id']) . '">' . $product['name'] . '</a>' . '</div>';
        }
        $html .= '</div>';

        wp_send_json_success([
            'success'    => true,
            'message'    => __('Wishlist fetched successfully', 'essential-addons-for-woocommerce'),
            'productIds' => $wishlist,
            'wishlist'   => $products,
            'html'       => $html
        ]);
    }

    public static function deleteFromWishList()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        $user_id = get_current_user_id();

        // Validate product ID
        if (empty($_POST['productId'])) {
            wp_send_json_error([
                'message' => __('No product ID provided.', 'essential-addons-for-woocommerce'),
                'success' => false
            ], 400);
        }

        $product_id = absint(wp_unslash($_POST['productId']));

        if (!$product_id) {
            wp_send_json_error([
                'message' => __('Invalid product ID.', 'essential-addons-for-woocommerce'),
                'success' => false
            ], 400);
        }

        // Get wishlist from user meta
        $wishlist = get_user_meta($user_id, 'ccpeaw_wishlist', true);

        $wishlist = is_array($wishlist) ? $wishlist : [];

        if (!in_array($product_id, $wishlist)) {
            wp_send_json_error([
                'message' => __('Product not found in wishlist.', 'essential-addons-for-woocommerce'),
                'success' => false
            ], 404);
        }

        // Remove the product ID and reindex the array
        $wishlist = array_values(array_diff($wishlist, [$product_id]));
        update_user_meta($user_id, 'ccpeaw_wishlist', $wishlist);

        wp_send_json_success([
            'message' => __('Product removed from wishlist successfully.', 'essential-addons-for-woocommerce'),
            'success' => true
        ]);
    }
}
