<?php

namespace CodeConfig\EAW\Ajax;

use CodeConfig\EAW\Utils\Helpers;

defined('ABSPATH') || exit('No direct script access allowed');

class Utilities
{
    public static function getCurrency()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        if (!isset($_POST['currency'])) {
            wp_send_json_error([
                'message' => __('Currency is required', 'essential-addons-for-woocommerce'),
                'success' => false
            ]);
        }

        $convertCurrency = Helpers::getCurrency(sanitize_text_field(wp_unslash($_POST['currency'])));

        if ($convertCurrency) {
            wp_send_json_success([
                'currency' => $convertCurrency,
                'success'  => true
            ]);
        }
    }
}
