<?php

namespace CodeConfig\EAW\Ajax;

use CodeConfig\EAW\Utils\Helpers;

defined('ABSPATH') || exit('No direct script access allowed');

class Users
{
    public static function getUserRoles()
    {

        check_ajax_referer('ccpeaw', 'eaw_nonce');

        if (!current_user_can('manage_options')) {
            wp_send_json_error([
                'success' => false,
                'message' => __('You do not have permission to perform this action', 'essential-addons-for-woocommerce'),
            ]);
        }

        wp_send_json_success([
            'success' => true,
            'roles'   => Helpers::getRoles(),
        ]);
    }
}
