<?php

namespace CodeConfig\EAW\Ajax;

use CodeConfig\EAW\Utils\Helpers;

defined('ABSPATH') || exit('No direct script access allowed');

class Settings
{
    public static function get()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        wp_send_json_success([
            'success'          => true,
            'data'             => Helpers::getSettings(),
            'default_settings' => ccpeaw_default_settings(),
            'message'          => __('Settings fetched successfully', 'essential-addons-for-woocommerce')
        ]);
    }

    public static function update()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');
        $data = isset($_POST['data']) ? sanitize_text_field(wp_unslash($_POST['data'])) : null;


        if (empty($data) || !is_array($data)) {
            wp_send_json_error(['message' => __('Invalid data received!', 'essential-addons-for-woocommerce')], 400);
        }

        $formattedData = [];
        // foreach ($data as $key => $value) {
        //     if (is_array($value)) {
        //         $formattedData[$key] = maybe_serialize($value);
        //     } elseif ($value === 'true') {
        //         $formattedData[$key] = '1';
        //     } elseif ($value === 'false') {
        //         $formattedData[$key] = '0';
        //     } else {
        //         $formattedData[$key] = sanitize_text_field($value);
        //     }
        // }

        // Save the settings
        $res = Helpers::updateSettings($formattedData);

        if (!$res) {
            wp_send_json_error(['message' => __('Something went wrong!', 'essential-addons-for-woocommerce')], 500);
        }

        wp_send_json_success(['message' => __('Settings updated successfully!', 'essential-addons-for-woocommerce')]);
    }
}
