<?php

namespace CodeConfig\EAW\Ajax;

use CodeConfig\EAW\Utils\Helpers;

defined('ABSPATH') || exit('No direct script access allowed');

class SaveCart
{
    public static function update()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        $cartName = __('New Saved Cart', 'essential-addons-for-woocommerce');

        if (isset($_POST['cart_name'])) {
            $cartName = sanitize_text_field(wp_unslash($_POST['cart_name']) ?? '');
        }

        $cartData = WC()->cart->get_cart();

        $cart_content = Helpers::setSaveCart($cartName, $cartData);


        if (!$cart_content) {
            wp_send_json_error([
                'success' => false,
                'message' => __('Failed to save cart!', 'essential-addons-for-woocommerce')
            ], 500);
        }

        return wp_send_json_success([
            'success' => true,
            'message' => __('Cart saved successfully!', 'essential-addons-for-woocommerce')
        ]);
    }

    public static function delete()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated -- Validated via isset check and sanitized below
        $saveCartId = isset($_POST['saveCartId']) ? sanitize_text_field(wp_unslash($_POST['saveCartId'])) : '';

        if (!$saveCartId) {
            wp_send_json_error([
                'success' => false,
                'message' => __('Failed to delete cart!', 'essential-addons-for-woocommerce')
            ], 500);
        }

        $result = Helpers::deleteSavedCart($saveCartId);

        if (!$result) {
            wp_send_json_error([
                'success' => false,
                'message' => __('Failed to delete cart!', 'essential-addons-for-woocommerce')
            ], 500);
        }

        return wp_send_json_success([
            'success' => true,
            'message' => __('Cart deleted successfully!', 'essential-addons-for-woocommerce')
        ]);
    }

    public static function restore()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated -- Validated via isset check and sanitized below
        $saveCartId = isset($_POST['saveCartId']) ? sanitize_text_field(wp_unslash($_POST['saveCartId'])) : '';

        if (!$saveCartId) {
            wp_send_json_error([
                'success' => false,
                'message' => __('Not cart ID found!', 'essential-addons-for-woocommerce')
            ], 500);
        }

        $result = Helpers::restoreSavedCart($saveCartId);

        return wp_send_json_success([
            'success' => true,
            'message' => __('Cart restored successfully!', 'essential-addons-for-woocommerce'),
            'data'    => $result['addedItems']
        ]);
    }

    public static function copy()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated -- Validated via isset check and sanitized below
        $cartId      = isset($_POST['cartId']) ? sanitize_text_field(wp_unslash($_POST['cartId'])) : '';
        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated -- Validated via isset check and sanitized below
        $currentPage = isset($_POST['currentPage']) ? sanitize_text_field(wp_unslash($_POST['currentPage'])) : '';

        if (!$cartId) {
            wp_send_json_error([
                'success' => false,
                'message' => __('Not cart ID found!', 'essential-addons-for-woocommerce')
            ], 500);
        }

        $result = Helpers::copySavedCart($cartId, $currentPage);

        if (!$result) {
            wp_send_json_error([
                'success' => false,
                'message' => __('Failed to copy cart!', 'essential-addons-for-woocommerce')
            ], 500);
        }

        return wp_send_json_success([
            'success' => true,
            'message' => __('Cart copied successfully!', 'essential-addons-for-woocommerce'),
            'data'    => $result
        ]);
    }

    public static function shareCartOnSocial()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated -- Validated via isset check and sanitized below
        $currentPage = isset($_POST['currentPage']) ? sanitize_text_field(wp_unslash($_POST['currentPage'])) : '';
        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated -- Validated via isset check and sanitized below
        $network     = isset($_POST['network']) ? sanitize_text_field(wp_unslash($_POST['network'])) : null;

        if (!$network) {
            wp_send_json_error([
                'success' => false,
                'message' => __('Network not found!', 'essential-addons-for-woocommerce')
            ], 500);
        }

        $result = Helpers::shareCartOnSocial($currentPage, $network);

        return wp_send_json_success([
            'success' => true,
            'message' => __('Cart generated successfully!', 'essential-addons-for-woocommerce'),
            'data'    => $result
        ]);
    }
}
