<?php

namespace CodeConfig\EAW\Ajax;

use CodeConfig\EAW\Utils\Helpers;

defined('ABSPATH') || exit('No direct script access allowed');

class ProductVariation
{
    public function doHooks()
    {
        add_filter('product_attributes_type_selector', [$this, 'addAttributeTypes']);
    }

    public function addAttributeTypes($types)
    {

        $more_types = [
            'color' => __('Color', 'essential-addons-for-woocommerce'),
            'image' => __('Image', 'essential-addons-for-woocommerce'),
            'label' => __('Button/Label', 'essential-addons-for-woocommerce'),
            'radio' => __('Radio', 'essential-addons-for-woocommerce'),
        ];

        $types = array_merge($types, $more_types);

        return $types;
    }

    public static function getProductAttributes()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        $attributes = Helpers::getProductAttributes();

        return wp_send_json_success([
            'success' => true,
            'data'    => $attributes,
        ]);
    }

    public static function addProductAttribute()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        $attrName        = sanitize_text_field(wp_unslash($_POST['label'] ?? ''));
        $attrType        = sanitize_text_field(wp_unslash($_POST['type'] ?? ''));
        $showInProduct   = filter_var(wp_unslash($_POST['showInProduct'] ?? true), FILTER_VALIDATE_BOOLEAN);
        $showInVariation = filter_var(wp_unslash($_POST['showInVariation'] ?? true), FILTER_VALIDATE_BOOLEAN);

        if (empty($attrName) || empty($attrTerms) || empty($attrType)) {
            wp_send_json_error([
                'message' => __('Attribute name, type, and terms are required.', 'essential-addons-for-woocommerce'),
                'success' => false,
            ]);
        }
    }


    public static function deleteProductAttribute()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        $attrName = isset($_POST['attrName']) ? sanitize_text_field(wp_unslash($_POST['attrName'])) : '';

        if (empty($attrName)) {
            wp_send_json_error([
                'message' => __('Attribute id is required', 'essential-addons-for-woocommerce'),
                'success' => false
            ]);
        }

        $attributes = Helpers::deleteProductAttribute($attrName);

        if (!$attributes) {
            wp_send_json_error([
                'message' => __('Attribute not found', 'essential-addons-for-woocommerce'),
                'success' => false
            ]);
        }

        return wp_send_json_success([
            'success' => true,
            'data'    => $attributes,
        ]);
    }

    public static function getProductAttributeTerms()
    {
        check_ajax_referer('ccpeaw', 'eaw_nonce');

        $attribute_taxonomies = wc_get_attribute_taxonomies();
        $all_terms            = [];

        if (!empty($attribute_taxonomies)) {
            foreach ($attribute_taxonomies as $taxonomy) {
                $taxonomy_name = wc_attribute_taxonomy_name($taxonomy->attribute_name);
                $terms         = get_terms([
                    'taxonomy'   => $taxonomy_name,
                    'hide_empty' => false,
                ]);

                foreach ($terms as $term) {
                    // Attach attribute name to each term
                    $term_data = [
                        'term_id'    => $term->term_id,
                        'label'      => $term->name,
                        'value'      => $term->slug,
                        'attribute'  => $taxonomy->attribute_name,
                    ];
                    $all_terms[] = $term_data;
                }
            }
        }

        return wp_send_json_success([
            'success' => true,
            'data'    => $all_terms,
        ]);
    }
}
